/*
 * Decompiled with CFR 0.152.
 */
package org.github.jamm;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.RuntimeMXBean;

abstract class MemoryLayoutSpecification {
    MemoryLayoutSpecification() {
    }

    abstract int getArrayHeaderSize();

    abstract int getObjectHeaderSize();

    abstract int getObjectAlignment();

    abstract int getReferenceSize();

    abstract int getSuperclassFieldPadding();

    abstract String impl();

    public String toString() {
        return "MemoryLayoutSpecification[getArrayHeaderSize=" + this.getArrayHeaderSize() + ",getObjectHeaderSize=" + this.getObjectHeaderSize() + ",getObjectAlignment=" + this.getObjectAlignment() + ",getReferenceSize=" + this.getReferenceSize() + ",getSuperclassFieldPadding=" + this.getSuperclassFieldPadding() + ",impl=" + this.impl() + "]";
    }

    static MemoryLayoutSpecification getEffectiveMemoryLayoutSpecification() {
        boolean hasDot;
        String dataModel = System.getProperty("sun.arch.data.model");
        if ("32".equals(dataModel)) {
            return new MemoryLayoutSpecification(){

                @Override
                public String impl() {
                    return "32";
                }

                @Override
                public int getArrayHeaderSize() {
                    return 12;
                }

                @Override
                public int getObjectHeaderSize() {
                    return 8;
                }

                @Override
                public int getObjectAlignment() {
                    return 8;
                }

                @Override
                public int getReferenceSize() {
                    return 4;
                }

                @Override
                public int getSuperclassFieldPadding() {
                    return 4;
                }
            };
        }
        boolean modernJvm = true;
        String strSpecVersion = System.getProperty("java.specification.version");
        boolean bl = hasDot = strSpecVersion.indexOf(46) != -1;
        if (hasDot && "1".equals(strSpecVersion.substring(0, strSpecVersion.indexOf(46)))) {
            int vmVersion;
            String strVmVersion = System.getProperty("java.vm.version");
            modernJvm = strVmVersion.startsWith("openj9") ? true : (vmVersion = Integer.parseInt(strVmVersion.substring(0, strVmVersion.indexOf(46)))) >= 17;
        }
        final int alignment = MemoryLayoutSpecification.getAlignment();
        if (modernJvm) {
            long maxMemory = 0L;
            for (MemoryPoolMXBean mp : ManagementFactory.getMemoryPoolMXBeans()) {
                maxMemory += mp.getUsage().getMax();
            }
            if (maxMemory < 0x780000000L) {
                return new MemoryLayoutSpecification(){

                    @Override
                    public String impl() {
                        return "modern";
                    }

                    @Override
                    public int getArrayHeaderSize() {
                        return 16;
                    }

                    @Override
                    public int getObjectHeaderSize() {
                        return 12;
                    }

                    @Override
                    public int getObjectAlignment() {
                        return alignment;
                    }

                    @Override
                    public int getReferenceSize() {
                        return 4;
                    }

                    @Override
                    public int getSuperclassFieldPadding() {
                        return 4;
                    }
                };
            }
        }
        return new MemoryLayoutSpecification(){

            @Override
            public String impl() {
                return "64";
            }

            @Override
            public int getArrayHeaderSize() {
                return 24;
            }

            @Override
            public int getObjectHeaderSize() {
                return 16;
            }

            @Override
            public int getObjectAlignment() {
                return alignment;
            }

            @Override
            public int getReferenceSize() {
                return 8;
            }

            @Override
            public int getSuperclassFieldPadding() {
                return 8;
            }
        };
    }

    private static int getAlignment() {
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        for (String arg : runtimeMxBean.getInputArguments()) {
            if (!arg.startsWith("-XX:ObjectAlignmentInBytes=")) continue;
            try {
                return Integer.parseInt(arg.substring("-XX:ObjectAlignmentInBytes=".length()));
            }
            catch (Exception exception) {
            }
        }
        return 8;
    }
}

