/*
 * Decompiled with CFR 0.152.
 */
package io.github.sukgu.support;

import io.github.sukgu.Shadow;
import io.github.sukgu.support.FindElementBy;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;

abstract class BaseBy
extends By {
    protected final String selector;
    protected final String selectorType;

    protected BaseBy(String selector, String selectorType) {
        this.selector = selector;
        this.selectorType = selectorType;
    }

    protected final WebDriver getWebDriver(SearchContext context) {
        WebDriver webDriver = context instanceof RemoteWebElement ? ((RemoteWebElement)context).getWrappedDriver() : (WebDriver)context;
        return webDriver;
    }

    public WebElement findElement(SearchContext context) {
        WebDriver webDriver = this.getWebDriver(context);
        if (context instanceof WebDriver) {
            context = null;
        }
        Shadow shadow = new Shadow(webDriver);
        if (this.selectorType.equals(FindElementBy.FindByBuilder.SelectorType.CSS_SELECTOR.toString())) {
            return shadow.findElement(this.selector);
        }
        if (this.selectorType.equals(FindElementBy.FindByBuilder.SelectorType.XPATH.toString())) {
            return shadow.findElementByXPath(this.selector);
        }
        return null;
    }

    public List<WebElement> findElements(SearchContext context) {
        WebDriver webDriver = this.getWebDriver(context);
        if (context instanceof WebDriver) {
            context = null;
        }
        Shadow shadow = new Shadow(webDriver);
        if (this.selectorType.equals(FindElementBy.FindByBuilder.SelectorType.CSS_SELECTOR.toString())) {
            return shadow.findElements(this.selector);
        }
        if (this.selectorType.equals(FindElementBy.FindByBuilder.SelectorType.XPATH.toString())) {
            return shadow.findElementsByXPath(this.selector);
        }
        return null;
    }
}

