/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.markup.builder.internal.markdown;

import io.github.swagger2markup.markup.builder.MarkupAdmonition;
import io.github.swagger2markup.markup.builder.MarkupBlockStyle;
import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import io.github.swagger2markup.markup.builder.MarkupLanguage;
import io.github.swagger2markup.markup.builder.MarkupTableColumn;
import io.github.swagger2markup.markup.builder.internal.AbstractMarkupDocBuilder;
import io.github.swagger2markup.markup.builder.internal.Markup;
import io.github.swagger2markup.markup.builder.internal.markdown.Markdown;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class MarkdownBuilder
extends AbstractMarkupDocBuilder {
    private static final Pattern TITLE_PATTERN = Pattern.compile(String.format("^(%s{1,%d})\\s+(.*)$", Markdown.TITLE, 6));
    private static final Map<MarkupBlockStyle, String> BLOCK_STYLE = new HashMap<MarkupBlockStyle, String>(){
        {
            this.put(MarkupBlockStyle.EXAMPLE, "");
            this.put(MarkupBlockStyle.LISTING, Markdown.LISTING.toString());
            this.put(MarkupBlockStyle.LITERAL, Markdown.LISTING.toString());
            this.put(MarkupBlockStyle.PASSTHROUGH, "");
            this.put(MarkupBlockStyle.SIDEBAR, "");
        }
    };

    public MarkdownBuilder() {
    }

    public MarkdownBuilder(String newLine) {
        super(newLine);
    }

    @Override
    protected MarkupLanguage getMarkupLanguage() {
        return MarkupLanguage.MARKDOWN;
    }

    @Override
    public MarkupDocBuilder copy(boolean copyBuffer) {
        MarkdownBuilder builder = new MarkdownBuilder(this.newLine);
        if (copyBuffer) {
            builder.documentBuilder = new StringBuilder(this.documentBuilder);
        }
        return builder.withAnchorPrefix(this.anchorPrefix);
    }

    @Override
    public MarkupDocBuilder documentTitle(String title) {
        this.documentTitle(Markdown.DOCUMENT_TITLE, title);
        return this;
    }

    @Override
    public MarkupDocBuilder sectionTitleLevel(int level, String title) {
        this.sectionTitleLevel(Markdown.TITLE, level, title);
        return this;
    }

    @Override
    public MarkupDocBuilder sectionTitleWithAnchorLevel(int level, String title, String anchor) {
        this.sectionTitleWithAnchorLevel(Markdown.TITLE, level, title, anchor);
        return this;
    }

    @Override
    public MarkupDocBuilder paragraph(String text, boolean hardbreaks) {
        Validate.notBlank((CharSequence)text, (String)"text must not be blank", (Object[])new Object[0]);
        text = text.trim();
        text = hardbreaks ? this.replaceNewLines(text, Markdown.LINE_BREAK + this.newLine) : this.replaceNewLines(text);
        this.documentBuilder.append(text).append(this.newLine).append(this.newLine);
        return this;
    }

    @Override
    public MarkupDocBuilder block(String text, final MarkupBlockStyle style, String title, MarkupAdmonition admonition) {
        if (admonition != null) {
            this.documentBuilder.append(StringUtils.capitalize((String)admonition.name().toLowerCase()));
        }
        if (title != null) {
            if (admonition != null) {
                this.documentBuilder.append(" | ");
            }
            this.documentBuilder.append(title);
        }
        if (admonition != null || title != null) {
            this.documentBuilder.append(" : ").append(this.newLine);
        }
        this.delimitedBlockText(new Markup(){

            @Override
            public String toString() {
                return (String)BLOCK_STYLE.get((Object)style);
            }
        }, text);
        return this;
    }

    @Override
    public MarkupDocBuilder listingBlock(String text, String language) {
        if (language != null) {
            text = language + " :" + this.newLine + text;
        }
        this.block(text, MarkupBlockStyle.LISTING);
        return this;
    }

    @Override
    public MarkupDocBuilder literalText(String text) {
        this.boldText(Markdown.LITERAL, text);
        return this;
    }

    @Override
    public MarkupDocBuilder boldText(String text) {
        this.boldText(Markdown.BOLD, text);
        return this;
    }

    @Override
    public MarkupDocBuilder italicText(String text) {
        this.italicText(Markdown.ITALIC, text);
        return this;
    }

    @Override
    public MarkupDocBuilder unorderedList(List<String> list) {
        this.unorderedList(Markdown.LIST_ENTRY, list);
        return this;
    }

    @Override
    public MarkupDocBuilder unorderedListItem(String item) {
        this.unorderedListItem(Markdown.LIST_ENTRY, item);
        return this;
    }

    private String normalizeAnchor(String anchor) {
        return this.normalizeAnchor(Markdown.SPACE_ESCAPE, anchor);
    }

    @Override
    public MarkupDocBuilder anchor(String anchor, String text) {
        this.documentBuilder.append("<a name=\"").append(this.normalizeAnchor(anchor)).append("\"></a>");
        return this;
    }

    @Override
    public MarkupDocBuilder crossReferenceRaw(String document, String anchor, String text) {
        if (text == null) {
            text = anchor.trim();
        }
        this.documentBuilder.append("[").append(text).append("]").append("(");
        if (document != null) {
            this.documentBuilder.append(document);
        }
        this.documentBuilder.append("#").append(anchor).append(")");
        return this;
    }

    @Override
    public MarkupDocBuilder crossReference(String document, String anchor, String text) {
        return this.crossReferenceRaw(document, this.normalizeAnchor(anchor), text);
    }

    private String formatTableCell(String cell) {
        cell = this.replaceNewLines(cell.trim(), "<br>");
        return cell.replace(Markdown.TABLE_COLUMN_DELIMITER.toString(), "\\" + Markdown.TABLE_COLUMN_DELIMITER.toString());
    }

    @Override
    public MarkupDocBuilder tableWithColumnSpecs(List<MarkupTableColumn> columnSpecs, List<List<String>> cells) {
        Validate.notEmpty(cells, (String)"cells must not be null", (Object[])new Object[0]);
        this.newLine();
        if (columnSpecs != null && !columnSpecs.isEmpty()) {
            Collection headerList = columnSpecs.stream().map(header -> this.formatTableCell(StringUtils.defaultString((String)header.header))).collect(Collectors.toList());
            this.documentBuilder.append(Markdown.TABLE_COLUMN_DELIMITER).append(StringUtils.join((Iterable)headerList, (String)Markdown.TABLE_COLUMN_DELIMITER.toString())).append(Markdown.TABLE_COLUMN_DELIMITER).append(this.newLine);
            this.documentBuilder.append(Markdown.TABLE_COLUMN_DELIMITER);
            columnSpecs.forEach(col -> {
                this.documentBuilder.append(StringUtils.repeat((String)Markdown.TABLE_ROW.toString(), (int)3));
                this.documentBuilder.append(Markdown.TABLE_COLUMN_DELIMITER);
            });
            this.documentBuilder.append(this.newLine);
        }
        for (List<String> row : cells) {
            Collection cellList = row.stream().map(cell -> this.formatTableCell(StringUtils.defaultString((String)cell))).collect(Collectors.toList());
            this.documentBuilder.append(Markdown.TABLE_COLUMN_DELIMITER).append(StringUtils.join((Iterable)cellList, (String)Markdown.TABLE_COLUMN_DELIMITER.toString())).append(Markdown.TABLE_COLUMN_DELIMITER).append(this.newLine);
        }
        this.newLine();
        return this;
    }

    @Override
    public MarkupDocBuilder newLine(boolean forceLineBreak) {
        this.newLine(Markdown.LINE_BREAK, forceLineBreak);
        return this;
    }

    @Override
    public MarkupDocBuilder importMarkup(Reader markupText, MarkupLanguage markupLanguage, int levelOffset) {
        this.importMarkupStyle1(TITLE_PATTERN, Markdown.TITLE, markupText, markupLanguage, levelOffset);
        return this;
    }

    @Override
    public String addFileExtension(String fileName) {
        return fileName + MarkupLanguage.MARKDOWN.getFileNameExtensions().get(0);
    }
}

