/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.adoc;

import io.github.swagger2markup.adoc.converter.internal.BlockImageNode;
import io.github.swagger2markup.adoc.converter.internal.BlockListingNode;
import io.github.swagger2markup.adoc.converter.internal.DelimitedBlockNode;
import io.github.swagger2markup.adoc.converter.internal.Delimiters;
import io.github.swagger2markup.adoc.converter.internal.IconNode;
import io.github.swagger2markup.adoc.converter.internal.ParagraphAttributes;
import io.github.swagger2markup.adoc.converter.internal.SourceNode;
import io.github.swagger2markup.adoc.converter.internal.Style;
import io.github.swagger2markup.adoc.converter.internal.TableCellHorizontalAlignment;
import io.github.swagger2markup.adoc.converter.internal.TableCellStyle;
import io.github.swagger2markup.adoc.converter.internal.TableCellVerticalAlignment;
import io.github.swagger2markup.adoc.converter.internal.TableNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.asciidoctor.ast.Block;
import org.asciidoctor.ast.Cell;
import org.asciidoctor.ast.ContentNode;
import org.asciidoctor.ast.DescriptionList;
import org.asciidoctor.ast.DescriptionListEntry;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.ListItem;
import org.asciidoctor.ast.PhraseNode;
import org.asciidoctor.ast.Row;
import org.asciidoctor.ast.Section;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.ast.Table;
import org.asciidoctor.converter.ConverterFor;
import org.asciidoctor.converter.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConverterFor(value="adoc")
public class AsciidocConverter
extends StringConverter {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String NAME = "adoc";
    private final Pattern emptyLineOrStartWith = Pattern.compile("(?m)^\\s*(?:\\r?\\n)|(?m)^\\s+");
    private final Pattern coListItemIdPattern = Pattern.compile(".*-(\\d+)");
    private final Pattern tableColumnsStylePattern = Pattern.compile("((\\d+)\\*)?([<^>])?(\\.[<^>])?(\\d+)?([adehlmsv])?");
    private static final List<String> attributeToExclude = Arrays.asList("localtime", "filetype", "asciidoctor-version", "doctime", "localyear", "docdate", "localdate", "localdatetime", "docdatetime", "backend", "basebackend", "doctitle", "docyear");
    private static final String[] supportedUrlSchemes = new String[]{"http", "https", "ftp", "irc", "mailto"};

    public AsciidocConverter(String backend, Map<String, Object> opts) {
        super(backend, opts);
    }

    public String convert(ContentNode node, String transform, Map<Object, Object> opts) {
        if (null == transform) {
            transform = node.getNodeName();
        }
        switch (transform) {
            case "inline_quoted": {
                return this.convertInlineQuoted((PhraseNode)node);
            }
            case "paragraph": {
                return this.convertParagraph((StructuralNode)node);
            }
            case "inline_anchor": {
                return this.convertInlineAnchor((PhraseNode)node);
            }
            case "section": {
                return this.convertSection((Section)node);
            }
            case "listing": {
                return this.convertListing((Block)node);
            }
            case "literal": {
                return this.convertLiteral((StructuralNode)node);
            }
            case "ulist": {
                return this.convertUList((org.asciidoctor.ast.List)node);
            }
            case "olist": {
                return this.convertOList((org.asciidoctor.ast.List)node);
            }
            case "dlist": {
                return this.convertDescriptionList((DescriptionList)node);
            }
            case "admonition": {
                return this.convertAdmonition((Block)node);
            }
            case "colist": {
                return this.convertCoList((org.asciidoctor.ast.List)node);
            }
            case "embedded": 
            case "document": {
                return this.convertEmbedded((Document)node);
            }
            case "example": {
                return this.convertExample((Block)node);
            }
            case "floating_title": {
                return this.convertFloatingTitle((StructuralNode)node);
            }
            case "image": {
                return this.convertImage((StructuralNode)node);
            }
            case "inline_break": {
                return this.convertInlineBreak(node);
            }
            case "inline_button": {
                return this.convertInlineButton(node);
            }
            case "inline_callout": {
                return this.convertInlineCallout(node);
            }
            case "inline_footnote": {
                return this.convertInlineFootnote(node);
            }
            case "inline_image": {
                return this.convertInlineImage((PhraseNode)node);
            }
            case "inline_indexterm": {
                return this.convertInlineIndexTerm(node);
            }
            case "inline_kbd": {
                return this.convertInlineKbd(node);
            }
            case "inline_menu": {
                return this.convertInlineMenu(node);
            }
            case "open": {
                return this.convertOpen((StructuralNode)node);
            }
            case "page_break": {
                return this.convertPageBreak(node);
            }
            case "preamble": {
                return this.convertPreamble((StructuralNode)node);
            }
            case "quote": {
                return this.convertQuote((StructuralNode)node);
            }
            case "sidebar": {
                return this.convertSidebar((StructuralNode)node);
            }
            case "stem": {
                return this.convertStem(node);
            }
            case "table": {
                return this.convertTable((Table)node);
            }
            case "thematic_break": {
                return this.convertThematicBreak(node);
            }
            case "verse": {
                return this.convertVerse((StructuralNode)node);
            }
            case "video": {
                return this.convertVideo(node);
            }
            case "toc": {
                return this.convertToc(node);
            }
            case "pass": {
                return this.convertPass(node);
            }
            case "audio": {
                return this.convertAudio(node);
            }
            case "list": {
                return this.convertList((org.asciidoctor.ast.List)node);
            }
            case "list_item": {
                return this.convertListItem((ListItem)node);
            }
        }
        this.logger.debug("Don't know how to convert transform: [" + transform + "] Node: " + node);
        return null;
    }

    String convertEmbedded(Document node) {
        this.logger.debug("convertEmbedded");
        StringBuilder sb = new StringBuilder();
        this.appendId((StructuralNode)node, sb);
        if (StringUtils.isNotBlank((CharSequence)node.getDoctitle())) {
            sb.append(this.repeat(node.getLevel() + 1, "=")).append(' ').append(StringEscapeUtils.unescapeHtml4((String)node.getDoctitle())).append(Delimiters.LINE_SEPARATOR);
        }
        Map attributes = node.getAttributes();
        this.appendAuthors(sb, attributes);
        this.appendRevisionDetails(sb, attributes);
        this.appendDocumentAttributes(sb, attributes);
        this.appendTrailingNewLine(sb);
        this.appendChildBlocks((StructuralNode)node, sb);
        return sb.toString();
    }

    private void appendAuthors(StringBuilder sb, Map<String, Object> attributes) {
        String authors;
        Long authorCount = (Long)attributes.getOrDefault("authorcount", 0L);
        if (authorCount == 1L) {
            String author = this.getAuthorDetail(attributes, "author", "email");
            if (StringUtils.isNotBlank((CharSequence)author)) {
                sb.append(author).append(Delimiters.LINE_SEPARATOR);
            }
        } else if (authorCount > 1L && StringUtils.isNotBlank((CharSequence)(authors = LongStream.rangeClosed(1L, authorCount).mapToObj(i -> this.getAuthorDetail(attributes, "author_" + i, "email_" + i)).collect(Collectors.joining("; "))))) {
            sb.append(authors).append(Delimiters.LINE_SEPARATOR);
        }
    }

    private void appendDocumentAttributes(StringBuilder sb, Map<String, Object> attributes) {
        attributes.forEach((k, v) -> {
            if (!attributeToExclude.contains(k) && v != null && !v.toString().isEmpty()) {
                sb.append(":").append((String)k).append(":").append(" ").append(v).append(Delimiters.LINE_SEPARATOR);
            }
        });
    }

    private void appendRevisionDetails(StringBuilder sb, Map<String, Object> attributes) {
        String revDetails = Stream.of(attributes.get("revnumber"), attributes.get("revdate")).filter(Objects::nonNull).filter(o -> !o.toString().isEmpty()).map(Object::toString).collect(Collectors.joining(", "));
        if (!revDetails.isEmpty()) {
            sb.append("v").append(revDetails).append(Delimiters.LINE_SEPARATOR);
        }
    }

    private String getAuthorDetail(Map<String, Object> attributes, String authorKey, String emailKey) {
        String author = attributes.getOrDefault(authorKey, "").toString();
        Object email = attributes.getOrDefault(emailKey, "").toString();
        if (StringUtils.isNotBlank((CharSequence)email)) {
            email = " <" + (String)email + ">";
        }
        return (author + (String)email).trim();
    }

    private String convertInlineAnchor(PhraseNode node) {
        String type;
        this.logger.debug("convertInlineAnchor");
        switch (type = node.getType()) {
            case "xref": {
                String text;
                String attrs;
                String path = Optional.ofNullable(node.getAttributes().get("path")).orElse("").toString();
                if (StringUtils.isNotBlank((CharSequence)path)) {
                    ArrayList<String> list = new ArrayList<String>();
                    if (StringUtils.isNotBlank((CharSequence)node.getRole())) {
                        list.add(" class=\"#{node.role}\"");
                    }
                    this.append_link_constraint_attrs((ContentNode)node, list);
                    attrs = String.join((CharSequence)" ", list);
                    text = StringUtils.isNotBlank((CharSequence)node.getText()) ? node.getText() : path;
                } else {
                    attrs = StringUtils.isNotBlank((CharSequence)node.getRole()) ? " class=\"" + node.getRole() + "\"" : "";
                    text = node.getText();
                    if (StringUtils.isNotBlank((CharSequence)text)) {
                        text = node.getAttributes().get("refid").toString();
                    }
                }
                return node.getTarget() + "[" + text + (String)(StringUtils.isNotBlank((CharSequence)attrs) ? "," + attrs : "") + "]";
            }
            case "ref": {
                return node.getId();
            }
            case "link": {
                String title;
                String role;
                ArrayList<Object> attrs = new ArrayList<Object>();
                String target = node.getTarget();
                String includePrefix = !StringUtils.startsWithAny((CharSequence)target, (CharSequence[])supportedUrlSchemes) ? "include::" : "";
                String text = node.getText();
                if (!target.equals(text)) {
                    attrs.add(text);
                }
                if (StringUtils.isNotBlank((CharSequence)node.getId())) {
                    attrs.add("id=\"" + node.getId() + "\"");
                }
                if (StringUtils.isNotBlank((CharSequence)(role = node.getRole())) && !role.equals("bare")) {
                    attrs.add("role=\"" + role + "\"");
                }
                if (StringUtils.isNotBlank((CharSequence)(title = node.getAttribute((Object)"title", (Object)"").toString()))) {
                    attrs.add("title=\"" + title + "\"");
                }
                return includePrefix + target + "[" + String.join((CharSequence)",", attrs) + "]";
            }
            case "bibref": {
                return node.getId() + "[" + (StringUtils.isNotBlank((CharSequence)node.getReftext()) ? node.getReftext() : node.getId()) + "]";
            }
        }
        this.logger.warn("unknown anchor type: " + node.getType());
        return null;
    }

    private String convertAdmonition(Block node) {
        this.logger.debug("convertAdmonition");
        StringBuilder sb = new StringBuilder();
        List blocks = node.getBlocks();
        if (blocks.isEmpty()) {
            sb.append(node.getStyle()).append(": ").append(node.getSource());
        } else {
            this.appendTitle((StructuralNode)node, sb);
            sb.append("[").append(node.getStyle()).append("]").append(Delimiters.LINE_SEPARATOR).append("====").append(Delimiters.LINE_SEPARATOR);
            this.appendChildBlocks((StructuralNode)node, sb);
            sb.append("====").append(Delimiters.LINE_SEPARATOR);
        }
        return sb.toString();
    }

    private String convertInlineQuoted(PhraseNode node) {
        this.logger.debug("convertInlineQuoted");
        StringBuilder sb = new StringBuilder();
        String marker = "";
        switch (node.getType()) {
            case "monospaced": {
                marker = "`";
                break;
            }
            case "emphasis": {
                marker = "_";
                break;
            }
            case "strong": {
                marker = "*";
                break;
            }
            case "superscript": {
                marker = "^";
                break;
            }
            case "subscript": {
                marker = "~";
                break;
            }
            case "double": 
            case "single": 
            case "mark": 
            case "asciimath": 
            case "latexmath": {
                marker = "";
            }
        }
        sb.append(marker).append(node.getText()).append(marker);
        return sb.toString();
    }

    private String convertFloatingTitle(StructuralNode node) {
        this.logger.debug("convertFloatingTitle");
        return "[discrete]" + Delimiters.LINE_SEPARATOR + this.repeat(node.getLevel() + 1, "=") + " " + node.getTitle() + Delimiters.LINE_SEPARATOR;
    }

    private String convertExample(Block node) {
        this.logger.debug("convertExample");
        StringBuilder sb = new StringBuilder();
        this.appendTitle((StructuralNode)node, sb);
        sb.append("====").append(Delimiters.LINE_SEPARATOR);
        this.appendChildBlocks((StructuralNode)node, sb);
        sb.append("====").append(Delimiters.LINE_SEPARATOR);
        return sb.toString();
    }

    private String convertInlineButton(ContentNode node) {
        this.logger.debug("convertInlineButton: name" + node.getNodeName());
        return "convertInlineButton";
    }

    private String convertInlineCallout(ContentNode node) {
        this.logger.debug("convertInlineCallout: name" + node.getNodeName());
        return "convertInlineCallout";
    }

    private String convertInlineBreak(ContentNode node) {
        this.logger.debug("convertInlineBreak: name" + node.getNodeName());
        return "convertInlineBreak";
    }

    private String convertInlineFootnote(ContentNode node) {
        this.logger.debug("convertInlineFootnote: name" + node.getNodeName());
        return "convertInlineFootnote";
    }

    private String convertInlineImage(PhraseNode node) {
        this.logger.debug("convertInlineImage");
        if (node.getType().equals("icon")) {
            return new IconNode((ContentNode)node).toAsciiDocContent();
        }
        return new BlockImageNode((ContentNode)node).toAsciiDocContent();
    }

    private String convertInlineIndexTerm(ContentNode node) {
        this.logger.debug("convertInlineIndexTerm: name" + node.getNodeName());
        return "convertInlineIndexTerm";
    }

    private String convertInlineKbd(ContentNode node) {
        this.logger.debug("convertInlineKbd: name" + node.getNodeName());
        return "convertInlineKbd";
    }

    private String convertInlineMenu(ContentNode node) {
        this.logger.debug("convertInlineMenu: name" + node.getNodeName());
        return "convertInlineMenu";
    }

    private String convertOpen(StructuralNode node) {
        this.logger.debug("convertOpen");
        StringBuilder sb = new StringBuilder();
        switch (node.getStyle()) {
            case "abstract": {
                sb.append("[").append("abstract").append("]").append(Delimiters.LINE_SEPARATOR);
                break;
            }
            case "open": {
                sb.append("--").append(Delimiters.LINE_SEPARATOR);
            }
        }
        sb.append(Optional.ofNullable(((Block)node).getSource()).orElse(""));
        this.appendChildBlocks(node, sb);
        if ("open".equals(node.getStyle())) {
            sb.append("--").append(Delimiters.LINE_SEPARATOR);
        }
        return sb.toString();
    }

    private String convertPageBreak(ContentNode node) {
        this.logger.debug("convertPageBreak: name" + node.getNodeName());
        return "<<<" + Delimiters.LINE_SEPARATOR;
    }

    private String convertQuote(StructuralNode node) {
        this.logger.debug("convertQuote");
        StringBuilder sb = new StringBuilder();
        this.appendTitle(node, sb);
        sb.append("[");
        ArrayList<String> attrs = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)node.getStyle())) {
            attrs.add("quote");
        }
        this.appendAttributeTo(node, attrs, "attribution");
        this.appendAttributeTo(node, attrs, "citetitle");
        sb.append(String.join((CharSequence)",", attrs)).append("]").append(Delimiters.LINE_SEPARATOR);
        List blocks = node.getBlocks();
        if (!blocks.isEmpty()) {
            sb.append("____").append(Delimiters.LINE_SEPARATOR);
            this.appendChildBlocks(node, sb);
            sb.append("____").append(Delimiters.LINE_SEPARATOR);
        } else {
            sb.append(((Block)node).getSource());
        }
        return sb.toString();
    }

    private String convertSidebar(StructuralNode node) {
        this.logger.debug("convertSidebar");
        StringBuilder sb = new StringBuilder();
        this.appendTitle(node, sb);
        this.appendChildBlocks(node, sb);
        return sb.toString();
    }

    private String convertStem(ContentNode node) {
        this.logger.debug("convertStem: name" + node.getNodeName());
        return "convertStem";
    }

    private String convertThematicBreak(ContentNode node) {
        this.logger.debug("convertThematicBreak: name" + node.getNodeName());
        return "'''" + Delimiters.LINE_SEPARATOR;
    }

    private String convertVerse(StructuralNode node) {
        this.logger.debug("convertVerse");
        StringBuilder sb = new StringBuilder();
        this.appendTitle(node, sb);
        sb.append("[");
        ArrayList<String> attrs = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)node.getStyle())) {
            attrs.add("verse");
        }
        this.appendAttributeTo(node, attrs, "attribution");
        this.appendAttributeTo(node, attrs, "citetitle");
        sb.append(String.join((CharSequence)",", attrs)).append("]").append(Delimiters.LINE_SEPARATOR);
        String source = ((Block)node).getSource();
        boolean matches = this.emptyLineOrStartWith.matcher(source).find();
        if (matches) {
            sb.append("____").append(Delimiters.LINE_SEPARATOR);
        }
        sb.append(source);
        if (matches) {
            sb.append(Delimiters.LINE_SEPARATOR).append("____");
        }
        this.appendTrailingNewLine(sb);
        return sb.toString();
    }

    private String convertVideo(ContentNode node) {
        this.logger.debug("convertVideo: name" + node.getNodeName());
        return "convertVideo";
    }

    private String convertToc(ContentNode node) {
        this.logger.debug("convertToc: name" + node.getNodeName());
        return "convertToc";
    }

    private String convertPass(ContentNode node) {
        this.logger.debug("convertPass: name" + node.getNodeName());
        return "convertPass";
    }

    private String convertAudio(ContentNode node) {
        this.logger.debug("convertAudio: name" + node.getNodeName());
        return "convertAudio";
    }

    private String convertCell(Cell node) {
        Document innerDocument;
        this.logger.debug("convertCell");
        StringBuilder sb = new StringBuilder();
        String source = node.getSource();
        if (StringUtils.isNotBlank((CharSequence)source)) {
            sb.append(source);
        }
        if (null != (innerDocument = node.getInnerDocument())) {
            this.appendChildBlocks((StructuralNode)innerDocument, sb, false);
        }
        return sb.toString().replaceAll(Delimiters.LINE_SEPARATOR + Delimiters.LINE_SEPARATOR + "+", Delimiters.LINE_SEPARATOR + Delimiters.LINE_SEPARATOR);
    }

    private String convertRow(Row node, List<TableCellStyle> columnStyles, String delimiterTableCell) {
        this.logger.debug("convertRow");
        StringBuilder sb = new StringBuilder();
        node.getCells().forEach(cell -> {
            Style style;
            TableCellVerticalAlignment vAlignment;
            int rowspan;
            boolean addNewLine = false;
            int colspan = cell.getColspan();
            if (colspan != 0) {
                addNewLine = true;
                sb.append(colspan).append('+');
            }
            if ((rowspan = cell.getRowspan()) != 0) {
                addNewLine = true;
                sb.append('.').append(rowspan).append('+');
            }
            int index = cell.getColumn().getColumnNumber() - 1;
            TableCellStyle tableCellStyle = columnStyles.size() > index ? (TableCellStyle)columnStyles.get(index) : null;
            boolean hAlignmentAdded = false;
            TableCellHorizontalAlignment hAlignment = TableCellHorizontalAlignment.fromName(cell.getHorizontalAlignment().name());
            if (null != hAlignment && (null == tableCellStyle || hAlignment != tableCellStyle.horizontalAlignment)) {
                hAlignmentAdded = true;
                addNewLine = true;
                sb.append(hAlignment.getDelimiter());
            }
            if (null != (vAlignment = TableCellVerticalAlignment.fromName(cell.getVerticalAlignment().name())) && (null == tableCellStyle || hAlignmentAdded || vAlignment != tableCellStyle.verticalAlignment)) {
                addNewLine = true;
                sb.append(vAlignment.getDelimiter());
            }
            if (null != (style = Style.fromName(cell.getAttribute((Object)"style", (Object)"").toString())) && (null == tableCellStyle || style != tableCellStyle.style)) {
                addNewLine = true;
                sb.append(style.getShortHand());
            }
            sb.append(delimiterTableCell).append(this.convertCell((Cell)cell));
            if (addNewLine) {
                sb.append(Delimiters.LINE_SEPARATOR);
            } else {
                sb.append(' ');
            }
        });
        return sb.toString();
    }

    private String convertTable(Table node) {
        this.logger.debug("convertTable");
        ArrayList<TableCellStyle> columnStyles = new ArrayList<TableCellStyle>();
        for (String col : node.getAttribute((Object)"cols", (Object)"").toString().split(",")) {
            Matcher matcher = this.tableColumnsStylePattern.matcher(col);
            if (!matcher.find()) continue;
            int multiplier = 1;
            String multiplierGroup = matcher.group(2);
            if (null != multiplierGroup) {
                try {
                    multiplier = Integer.parseInt(multiplierGroup);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            int width = 0;
            try {
                width = Integer.parseInt(matcher.group(5));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            TableCellStyle tableCellStyle = new TableCellStyle(TableCellHorizontalAlignment.fromString(matcher.group(3)), TableCellVerticalAlignment.fromString(matcher.group(4)), Style.fromString(matcher.group(6)), width);
            for (int i = 0; i < multiplier; ++i) {
                columnStyles.add(tableCellStyle);
            }
        }
        StringBuilder sb = new StringBuilder();
        this.appendTitle((StructuralNode)node, sb);
        sb.append(new TableNode(node).toAsciiDocContent());
        boolean innerTable = this.isInnerTable((ContentNode)node);
        String tableDelimiter = innerTable ? "!===" : "|===";
        String cellDelimiter = innerTable ? "!" : "|";
        sb.append(tableDelimiter).append(Delimiters.LINE_SEPARATOR);
        this.appendRows(node.getHeader(), sb, columnStyles, cellDelimiter);
        this.appendRows(node.getBody(), sb, columnStyles, cellDelimiter);
        this.appendRows(node.getFooter(), sb, columnStyles, cellDelimiter);
        sb.append(tableDelimiter).append(Delimiters.LINE_SEPARATOR);
        return sb.toString();
    }

    private boolean isInnerTable(ContentNode node) {
        ContentNode parent;
        if (null != node && null != (parent = node.getParent())) {
            return parent instanceof Table || this.isInnerTable(parent);
        }
        return false;
    }

    private void appendRows(List<Row> rows, StringBuilder sb, List<TableCellStyle> columnStyles, String delimiterTableCell) {
        rows.forEach(row -> sb.append(this.convertRow((Row)row, columnStyles, delimiterTableCell)).append(Delimiters.LINE_SEPARATOR));
    }

    private String convertDescriptionList(DescriptionList node) {
        String style;
        this.logger.debug("convertDescriptionList");
        StringBuilder sb = new StringBuilder();
        this.appendTitle((StructuralNode)node, sb);
        switch (style = Optional.ofNullable(node.getStyle()).orElse("")) {
            case "horizontal": {
                sb.append("[").append("horizontal").append("]").append(Delimiters.LINE_SEPARATOR);
                node.getItems().forEach(item -> sb.append(this.convertDescriptionListEntry((DescriptionListEntry)item, node.getLevel(), false)));
                break;
            }
            case "qanda": {
                sb.append("[").append("qanda").append("]").append(Delimiters.LINE_SEPARATOR);
            }
            default: {
                node.getItems().forEach(item -> sb.append(this.convertDescriptionListEntry((DescriptionListEntry)item, node.getLevel(), true)));
            }
        }
        this.appendTrailingNewLine(sb);
        return sb.toString();
    }

    private String convertDescriptionListEntry(DescriptionListEntry node, int level, Boolean descriptionOnNewLine) {
        this.logger.debug("convertDescriptionListEntry");
        StringBuilder sb = new StringBuilder();
        String delimiter = this.repeat(level + 1, ":");
        String entryTerms = node.getTerms().stream().map(term -> Optional.ofNullable(term.getSource()).orElse("")).collect(Collectors.joining(delimiter + Delimiters.LINE_SEPARATOR, "", delimiter));
        sb.append(entryTerms);
        ListItem description = node.getDescription();
        if (null != description) {
            String desc;
            if (descriptionOnNewLine.booleanValue()) {
                sb.append(Delimiters.LINE_SEPARATOR);
            }
            if (StringUtils.isNotBlank((CharSequence)(desc = Optional.ofNullable(description.getSource()).orElse("")))) {
                sb.append(desc).append(Delimiters.LINE_SEPARATOR);
            }
            this.appendChildBlocks((StructuralNode)description, sb);
        }
        return sb.toString();
    }

    private String convertListing(Block node) {
        this.logger.debug("convertListing");
        StringBuilder sb = new StringBuilder();
        this.appendTitle((StructuralNode)node, sb);
        if ("source".equals(node.getStyle())) {
            sb.append(new SourceNode(node).toAsciiDocContent());
        } else {
            sb.append(new BlockListingNode(node).toAsciiDocContent());
        }
        return sb.toString();
    }

    private String convertUList(org.asciidoctor.ast.List node) {
        this.logger.debug("convertUList");
        StringBuilder sb = new StringBuilder();
        this.appendStyle((StructuralNode)node, sb);
        this.appendTitle((StructuralNode)node, sb);
        this.appendChildBlocks((StructuralNode)node, sb);
        this.appendTrailingNewLine(sb);
        return sb.toString();
    }

    private String convertOList(org.asciidoctor.ast.List node) {
        this.logger.debug("convertOList");
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> attrs = new ArrayList<Object>();
        String start = node.getAttribute((Object)"start", (Object)"").toString();
        if (StringUtils.isNotBlank((CharSequence)start)) {
            attrs.add("start=" + start);
        }
        if (node.isOption((Object)"reversed")) {
            attrs.add("%reversed");
        }
        if (!attrs.isEmpty()) {
            sb.append("[").append(String.join((CharSequence)",", attrs)).append("]").append(Delimiters.LINE_SEPARATOR);
        }
        this.appendTitle((StructuralNode)node, sb);
        this.appendChildBlocks((StructuralNode)node, sb);
        this.appendTrailingNewLine(sb);
        return sb.toString();
    }

    private String convertCoList(org.asciidoctor.ast.List node) {
        this.logger.debug("convertCoList");
        StringBuilder result = new StringBuilder();
        this.appendChildBlocks((StructuralNode)node, result);
        return result.toString();
    }

    private String convertListItem(ListItem node) {
        this.logger.debug("convertListItem");
        StringBuilder sb = new StringBuilder();
        String marker = Optional.ofNullable(node.getMarker()).orElse(this.repeat(node.getLevel(), "*"));
        String coids = node.getAttribute((Object)"coids", (Object)"").toString();
        Matcher matcher = this.coListItemIdPattern.matcher(coids);
        if (matcher.find()) {
            marker = marker.replaceAll("\\d+", matcher.group(1));
        }
        sb.append(marker).append(" ");
        if (node.hasAttribute((Object)"checkbox")) {
            sb.append('[');
            if (node.hasAttribute((Object)"checked")) {
                sb.append('x');
            } else {
                sb.append(' ');
            }
            sb.append(']').append(' ');
        }
        sb.append(Optional.ofNullable(node.getSource()).orElse(""));
        this.appendTrailingNewLine(sb);
        this.appendChildBlocks((StructuralNode)node, sb);
        return sb.toString();
    }

    private String convertList(org.asciidoctor.ast.List node) {
        this.logger.debug("convertList");
        return node.getContent().toString();
    }

    private String convertPreamble(StructuralNode node) {
        this.logger.debug("convertPreamble");
        return node.getContent().toString();
    }

    private String convertImage(StructuralNode node) {
        this.logger.debug("convertImage");
        StringBuilder sb = new StringBuilder();
        this.appendTitle(node, sb);
        this.appendRoles(node, sb);
        sb.append(new BlockImageNode((ContentNode)node).toAsciiDocContent());
        return sb.toString();
    }

    private String convertLiteral(StructuralNode node) {
        this.logger.debug("convertLiteral");
        return "[" + node.getContext() + "]" + Delimiters.LINE_SEPARATOR + StringEscapeUtils.unescapeHtml4((String)node.getContent().toString()) + Delimiters.LINE_SEPARATOR;
    }

    private String convertParagraph(StructuralNode node) {
        this.logger.debug("convertParagraph");
        StringBuilder sb = new StringBuilder();
        this.appendTitle(node, sb);
        sb.append(new ParagraphAttributes(node).toAsciiDocContent());
        this.appendSource((Block)node, sb);
        this.appendTrailingNewLine(sb);
        return sb.toString();
    }

    private String convertSection(Section node) {
        this.logger.debug("convertSection");
        StringBuilder sb = new StringBuilder();
        this.appendId((StructuralNode)node, sb);
        sb.append(new DelimitedBlockNode((StructuralNode)node).toAsciiDocContent()).append(StringUtils.repeat((String)"=", (int)(node.getLevel() + 1))).append(" ").append(StringEscapeUtils.unescapeHtml4((String)node.getTitle())).append(Delimiters.LINE_SEPARATOR);
        this.appendChildBlocks((StructuralNode)node, sb);
        this.appendTrailingNewLine(sb);
        return sb.toString();
    }

    private void append_link_constraint_attrs(ContentNode node, List<String> attrs) {
        String rel = node.getAttribute((Object)"nofollow-option").toString();
        String window = node.getAttributes().get("window").toString();
        if (StringUtils.isNotBlank((CharSequence)window)) {
            attrs.add("target = \"#{window}\"");
            if (window.equals("_blank") || node.getAttributes().containsKey("option-noopener")) {
                if (StringUtils.isNotBlank((CharSequence)rel)) {
                    attrs.add("rel = \"" + rel + "noopener\"");
                } else {
                    attrs.add(" rel=\"noopener\"");
                }
            }
        } else if (StringUtils.isNotBlank((CharSequence)rel)) {
            attrs.add("rel = " + rel + "\"");
        }
    }

    private String repeat(int count, String with) {
        return new String(new char[count]).replace("\u0000", with);
    }

    private void appendChildBlocks(StructuralNode parentNode, StringBuilder sb) {
        this.appendChildBlocks(parentNode, sb, true);
    }

    private void appendChildBlocks(StructuralNode parentNode, StringBuilder sb, boolean addTrailingLineSeparator) {
        boolean isParentAListItem = parentNode instanceof ListItem || parentNode instanceof DescriptionListEntry;
        parentNode.getBlocks().forEach(childNode -> {
            String childNodeValue = childNode.convert();
            if (StringUtils.isNotBlank((CharSequence)childNodeValue)) {
                if (isParentAListItem && (sb.toString().contains("+" + Delimiters.LINE_SEPARATOR) || !(childNode instanceof org.asciidoctor.ast.List) && !(childNode instanceof DescriptionList))) {
                    sb.append('+').append(Delimiters.LINE_SEPARATOR);
                }
                sb.append(childNodeValue);
                if (addTrailingLineSeparator && !StringUtils.endsWith((CharSequence)childNodeValue, (CharSequence)Delimiters.LINE_SEPARATOR)) {
                    sb.append(Delimiters.LINE_SEPARATOR);
                }
            }
        });
    }

    private void appendTrailingNewLine(StringBuilder sb) {
        if (!sb.toString().endsWith(Delimiters.LINE_SEPARATOR + Delimiters.LINE_SEPARATOR)) {
            sb.append(Delimiters.LINE_SEPARATOR);
        }
    }

    private void appendId(StructuralNode node, StringBuilder sb) {
        String id = node.getId();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            sb.append("[[").append(id).append("]]").append(Delimiters.LINE_SEPARATOR);
        }
    }

    private void appendSource(Block node, StringBuilder sb) {
        String source = node.getSource();
        if (StringUtils.isNotBlank((CharSequence)source)) {
            sb.append(source).append(Delimiters.LINE_SEPARATOR);
        }
    }

    private void appendTitle(StructuralNode node, StringBuilder sb) {
        String title = node.getTitle();
        if (StringUtils.isNotBlank((CharSequence)title)) {
            sb.append(".").append(StringEscapeUtils.unescapeHtml4((String)title)).append(Delimiters.LINE_SEPARATOR);
        }
    }

    private void appendStyle(StructuralNode node, StringBuilder sb) {
        String style = node.getStyle();
        if (StringUtils.isNotBlank((CharSequence)style)) {
            sb.append("[").append(style).append("]").append(Delimiters.LINE_SEPARATOR);
        }
    }

    private void appendRoles(StructuralNode node, StringBuilder sb) {
        List roles = node.getRoles();
        if (!roles.isEmpty()) {
            sb.append("[").append(".").append(String.join((CharSequence)".", roles)).append("]").append(Delimiters.LINE_SEPARATOR);
        }
    }

    private void appendAttributeTo(StructuralNode node, List<String> attrs, String name) {
        String attribution = node.getAttribute((Object)name, (Object)"").toString();
        if (StringUtils.isNotBlank((CharSequence)attribution)) {
            attrs.add(attribution);
        }
    }
}

