/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.adoc.ast.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.asciidoctor.ast.ContentNode;
import org.asciidoctor.ast.Document;

public abstract class ContentNodeImpl
implements ContentNode {
    private String id;
    private final String context;
    private final Map<String, Object> attributes;
    private final List<String> roles;
    private final ContentNode parent;

    public ContentNodeImpl(ContentNode parent, String context) {
        this(parent, context, new HashMap<String, Object>(), new ArrayList<String>());
    }

    public ContentNodeImpl(ContentNode parent, String context, Map<String, Object> attributes, List<String> roles) {
        this.parent = parent;
        this.context = context;
        this.attributes = attributes;
        this.roles = roles;
    }

    @Deprecated
    public String id() {
        return this.getId();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id.toLowerCase().replaceAll("\\s+", "_");
    }

    @Deprecated
    public String context() {
        return this.getContext();
    }

    public String getContext() {
        return this.context;
    }

    @Deprecated
    public ContentNode parent() {
        return this.getParent();
    }

    public ContentNode getParent() {
        return this.parent;
    }

    @Deprecated
    public Document document() {
        return this.getDocument();
    }

    public Document getDocument() {
        throw new UnsupportedOperationException("Not implemented, yet");
    }

    public String getNodeName() {
        return this.getContext();
    }

    public boolean isInline() {
        return false;
    }

    public boolean isBlock() {
        return false;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Deprecated
    public Object getAttr(Object name, Object defaultValue, boolean inherit) {
        return this.getAttribute(name, defaultValue, inherit);
    }

    @Deprecated
    public Object getAttr(Object name, Object defaultValue) {
        return this.getAttribute(name, defaultValue);
    }

    @Deprecated
    public Object getAttr(Object name) {
        return this.getAttribute(name);
    }

    public Object getAttribute(Object name, Object defaultValue, boolean inherit) {
        return this.getAttribute(name, defaultValue);
    }

    public Object getAttribute(Object name, Object defaultValue) {
        return this.attributes.getOrDefault(name, defaultValue);
    }

    public Object getAttribute(Object name) {
        return this.attributes.get(name);
    }

    @Deprecated
    public boolean isAttr(Object name, Object expected, boolean inherit) {
        return this.isAttribute(name, expected, inherit);
    }

    @Deprecated
    public boolean isAttr(Object name, Object expected) {
        return this.isAttribute(name, expected);
    }

    public boolean isAttribute(Object name, Object expected, boolean inherit) {
        return this.isAttribute(name, expected);
    }

    public boolean isAttribute(Object name, Object expected) {
        try {
            if (this.attributes.containsKey(name)) {
                return this.attributes.get(name).equals(expected);
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Deprecated
    public boolean hasAttr(Object name) {
        return this.hasAttribute(name);
    }

    @Deprecated
    public boolean hasAttr(Object name, boolean inherited) {
        return this.hasAttribute(name, inherited);
    }

    public boolean hasAttribute(Object name) {
        return this.attributes.containsKey(name);
    }

    public boolean hasAttribute(Object name, boolean inherited) {
        return this.hasAttribute(name);
    }

    @Deprecated
    public boolean setAttr(Object name, Object value, boolean overwrite) {
        return this.setAttribute(name, value, overwrite);
    }

    public boolean setAttribute(Object name, Object value, boolean overwrite) {
        return this.setAttribute((String)name, value, overwrite);
    }

    public boolean setAttribute(String name, Object value, boolean overwrite) {
        try {
            if (overwrite) {
                this.attributes.put(name, value);
            } else {
                this.attributes.putIfAbsent(name, value);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Object removeAttribute(String name) {
        return this.attributes.remove(name);
    }

    public boolean removeAttribute(String name, Object value) {
        return this.attributes.remove(name, value);
    }

    public boolean isOption(Object name) {
        try {
            Object o = this.attributes.get(name + "-option");
            return null != o && o.toString().equals("");
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public boolean setOption(String name) {
        return this.setAttribute(name + "-option", (Object)"", true);
    }

    public Object removeOption(String name) {
        return this.removeAttribute(name + "-option");
    }

    public boolean isRole() {
        return false;
    }

    public String getRole() {
        return String.join((CharSequence)",", this.roles);
    }

    @Deprecated
    public String role() {
        return this.getRole();
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public boolean hasRole(String role) {
        return this.roles.contains(role);
    }

    public void addRole(String role) {
        this.roles.add(role);
    }

    public void removeRole(String role) {
        this.roles.remove(role);
    }

    public boolean isReftext() {
        throw new UnsupportedOperationException("Not implemented, yet");
    }

    public String getReftext() {
        throw new UnsupportedOperationException("Not implemented, yet");
    }

    public String iconUri(String name) {
        throw new UnsupportedOperationException("Not implemented, yet");
    }

    public String mediaUri(String target) {
        throw new UnsupportedOperationException("Not implemented, yet");
    }

    public String imageUri(String targetImage) {
        throw new UnsupportedOperationException("Not implemented, yet");
    }

    public String imageUri(String targetImage, String assetDirKey) {
        throw new UnsupportedOperationException("Not implemented, yet");
    }

    public String readAsset(String path, Map<Object, Object> opts) {
        throw new UnsupportedOperationException("Not implemented, yet");
    }

    public String normalizeWebPath(String path, String start, boolean preserveUriTarget) {
        throw new UnsupportedOperationException("Not implemented, yet");
    }
}

