/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.adoc.ast.impl;

import io.github.swagger2markup.adoc.AsciidocConverter;
import io.github.swagger2markup.adoc.ast.impl.ContentNodeImpl;
import io.github.swagger2markup.adoc.ast.impl.CursorImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.asciidoctor.ast.ContentNode;
import org.asciidoctor.ast.Cursor;
import org.asciidoctor.ast.StructuralNode;

public class StructuralNodeImpl
extends ContentNodeImpl
implements StructuralNode {
    private String title;
    private String caption;
    private String style;
    private final Object content;
    private final List<StructuralNode> blocks;
    private Integer level;
    private final String contentModel;
    private List<String> subs;
    private final AsciidocConverter converter = new AsciidocConverter("adoc", new HashMap<String, Object>());

    public StructuralNodeImpl(StructuralNode parent, String context) {
        this(parent, context, new HashMap<String, Object>());
    }

    public StructuralNodeImpl(StructuralNode parent, String context, Map<String, Object> attributes) {
        this(parent, context, attributes, null);
    }

    public StructuralNodeImpl(StructuralNode parent, String context, Object content) {
        this(parent, context, new HashMap<String, Object>(), content);
    }

    public StructuralNodeImpl(StructuralNode parent, String context, Map<String, Object> attributes, Object content) {
        this(parent, context, attributes, new ArrayList<String>(), content, new ArrayList<StructuralNode>(), "", new ArrayList<String>());
    }

    public StructuralNodeImpl(StructuralNode parent, String context, Map<String, Object> attributes, List<String> roles, Object content, List<StructuralNode> blocks, String contentModel, List<String> subs) {
        this(parent, context, attributes, roles, content, blocks, StructuralNodeImpl.calculateLevel(parent), contentModel, subs);
    }

    public StructuralNodeImpl(StructuralNode parent, String context, Map<String, Object> attributes, List<String> roles, Object content, List<StructuralNode> blocks, Integer level, String contentModel, List<String> subs) {
        super((ContentNode)parent, context, attributes, roles);
        this.content = content;
        this.blocks = blocks;
        this.level = level;
        this.contentModel = contentModel;
        this.subs = subs;
    }

    @Deprecated
    public String title() {
        return this.getTitle();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    @Deprecated
    public String style() {
        return this.getStyle();
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    @Deprecated
    public List<StructuralNode> blocks() {
        return this.getBlocks();
    }

    public List<StructuralNode> getBlocks() {
        return this.blocks;
    }

    public void append(StructuralNode block) {
        this.blocks.add(block);
    }

    @Deprecated
    public Object content() {
        return this.getContent();
    }

    public Object getContent() {
        return this.content;
    }

    public String convert() {
        return this.converter.convert((ContentNode)this, (String)null, (Map)new HashMap());
    }

    public int getLevel() {
        return this.level;
    }

    public Cursor getSourceLocation() {
        return new CursorImpl();
    }

    public String getContentModel() {
        return this.contentModel;
    }

    public List<String> getSubstitutions() {
        return this.subs;
    }

    public boolean isSubstitutionEnabled(String substitution) {
        return this.subs.contains(substitution);
    }

    public void removeSubstitution(String substitution) {
        this.subs.remove(substitution);
    }

    public void addSubstitution(String substitution) {
        this.subs.add(substitution);
    }

    public void prependSubstitution(String substitution) {
    }

    public void setSubstitutions(String ... substitutions) {
        this.subs = Arrays.asList(substitutions);
    }

    public List<StructuralNode> findBy(Map<Object, Object> selector) {
        throw new UnsupportedOperationException("Not implemented, yet");
    }

    protected static Integer calculateLevel(StructuralNode parent) {
        return null != parent ? parent.getLevel() + 1 : 0;
    }
}

