/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.adoc.ast.impl;

import io.github.swagger2markup.adoc.ast.impl.CellImpl;
import io.github.swagger2markup.adoc.ast.impl.ColumnImpl;
import io.github.swagger2markup.adoc.ast.impl.DocumentImpl;
import io.github.swagger2markup.adoc.ast.impl.ParagraphBlockImpl;
import io.github.swagger2markup.adoc.ast.impl.RowImpl;
import io.github.swagger2markup.adoc.ast.impl.StructuralNodeImpl;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.asciidoctor.ast.Cell;
import org.asciidoctor.ast.Column;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.Row;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.ast.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableImpl
extends StructuralNodeImpl
implements Table {
    public static final String OPTION_UNBREAKABLE = "unbreakable";
    public static final String OPTION_BREAKABLE = "breakable";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String CONTEXT = "table";
    private static final String FRAME_ATTR = "frame";
    private static final String GRID_ATTR = "grid";
    private RowList headerRows;
    private RowList bodyRows;
    private RowList footerRows;
    private List<Column> columns = new ArrayList<Column>();

    public TableImpl(StructuralNode parent) {
        this(parent, new HashMap<String, Object>(), new ArrayList<String>());
    }

    public TableImpl(StructuralNode parent, Map<String, Object> attributes, List<String> roles) {
        this(parent, attributes, roles, TableImpl.calculateLevel(parent));
    }

    public TableImpl(StructuralNode parent, Map<String, Object> attributes, List<String> roles, Integer level) {
        this(parent, attributes, roles, null, new ArrayList<StructuralNode>(), level, "", new ArrayList<String>());
    }

    public TableImpl(StructuralNode parent, Map<String, Object> attributes, List<String> roles, Object content, List<StructuralNode> blocks, Integer level, String contentModel, List<String> subs) {
        super(parent, CONTEXT, attributes, roles, content, blocks, level, contentModel, subs);
        this.headerRows = new RowList(new ArrayList<Row>());
        this.bodyRows = new RowList(new ArrayList<Row>());
        this.footerRows = new RowList(new ArrayList<Row>());
    }

    public boolean hasHeaderOption() {
        return this.isOption("header");
    }

    public String getFrame() {
        return (String)this.getAttribute(FRAME_ATTR, "all");
    }

    public void setFrame(String frame) {
        this.setAttribute(FRAME_ATTR, (Object)frame, true);
    }

    public String getGrid() {
        return (String)this.getAttribute(GRID_ATTR, "all");
    }

    public void setGrid(String grid) {
        this.setAttribute(GRID_ATTR, (Object)grid, true);
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public List<Row> getHeader() {
        return this.headerRows;
    }

    public void setHeaderRow(Row row) {
        this.headerRows.clear();
        this.headerRows.add(row);
        this.scanRowForColumns(row);
    }

    public void setHeaderRow(List<Cell> cells) {
        this.setHeaderRow(new RowImpl(cells));
    }

    public void setHeaderRow(String ... documentContents) {
        this.headerRows.clear();
        this.headerRows.add(this.generateRow(documentContents));
    }

    public RowImpl generateRow(Document ... innerDocs) {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        for (int i = 0; i < innerDocs.length; ++i) {
            Column column = null;
            try {
                column = this.columns.get(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (null == column) {
                ColumnImpl newColumn = new ColumnImpl(this);
                newColumn.setColumnNumber(i + 1);
                column = newColumn;
                this.addColumnAt(column, i);
            }
            cells.add(new CellImpl(column, innerDocs[i]));
        }
        return new RowImpl(cells);
    }

    public RowImpl generateRow(String ... documentContents) {
        Document[] documents = (Document[])Arrays.stream(documentContents).map(documentContent -> {
            DocumentImpl innerDoc = new DocumentImpl();
            ParagraphBlockImpl paragraph = new ParagraphBlockImpl(innerDoc);
            paragraph.setSource((String)documentContent);
            innerDoc.append(paragraph);
            return innerDoc;
        }).toArray(Document[]::new);
        return this.generateRow(documents);
    }

    public List<Row> getBody() {
        return this.bodyRows;
    }

    public void setBodyRows(List<Row> rows) {
        this.bodyRows.clear();
        this.bodyRows.addAll(rows);
        this.bodyRows.forEach(this::scanRowForColumns);
    }

    public void addRow(Row row) {
        this.bodyRows.add(row);
        this.scanRowForColumns(row);
    }

    public void addRow(List<Cell> cells) {
        this.bodyRows.add(new RowImpl(cells));
    }

    public RowImpl addRow(Document ... documentContents) {
        RowImpl row = this.generateRow(documentContents);
        this.bodyRows.add(row);
        return row;
    }

    public RowImpl addRow(String ... documentContents) {
        RowImpl row = this.generateRow(documentContents);
        this.bodyRows.add(row);
        return row;
    }

    public List<Row> getFooter() {
        return this.footerRows;
    }

    public void setFooterRow(Row row) {
        this.footerRows.clear();
        this.footerRows.add(row);
        this.scanRowForColumns(row);
    }

    public void setFooterRow(String ... documentContents) {
        this.footerRows.clear();
        this.footerRows.add(this.generateRow(documentContents));
    }

    private void scanRowForColumns(Row row) {
        row.getCells().forEach(cell -> {
            Column column = cell.getColumn();
            int i = column.getColumnNumber() - 1;
            this.addColumnAt(column, i);
        });
    }

    private void addColumnAt(Column column, int i) {
        if (this.columns.size() >= i) {
            this.columns.add(i, column);
        } else {
            while (this.columns.size() < i) {
                this.columns.add(this.columns.size(), null);
            }
            this.columns.add(column);
        }
    }

    public void setFooterRow(List<Cell> cells) {
        this.setFooterRow(new RowImpl(cells));
    }

    protected static Integer calculateLevel(StructuralNode parent) {
        int level = 1;
        if (parent instanceof Table) {
            level = parent.getLevel() + 1;
        }
        return level;
    }

    class RowList
    extends AbstractList<Row> {
        private final List<Row> rubyArray;

        private RowList(List<Row> rubyArray) {
            this.rubyArray = rubyArray;
        }

        @Override
        public int size() {
            return this.rubyArray.size();
        }

        @Override
        public boolean isEmpty() {
            return this.rubyArray.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.rubyArray.contains(o);
        }

        @Override
        public boolean add(Row row) {
            boolean changed = false;
            try {
                changed = this.rubyArray.add(row);
                TableImpl.this.setAttribute("rowcount", (Object)this.size(), true);
            }
            catch (Exception e) {
                TableImpl.this.logger.debug("Couldn't add row", (Throwable)e);
            }
            return changed;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof RowImpl)) {
                return false;
            }
            try {
                boolean changed = this.rubyArray.remove(o);
                TableImpl.this.setAttribute("rowcount", (Object)this.size(), true);
                return changed;
            }
            catch (Exception e) {
                TableImpl.this.logger.debug("Couldn't add row", (Throwable)e);
                return false;
            }
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            this.rubyArray.clear();
            TableImpl.this.setAttribute("rowcount", (Object)this.size(), true);
        }

        @Override
        public Row get(int index) {
            return this.rubyArray.get(index);
        }

        @Override
        public Row set(int index, Row element) {
            Row oldRow = this.get(index);
            this.rubyArray.set(index, element);
            return oldRow;
        }

        @Override
        public void add(int index, Row element) {
            this.rubyArray.add(index, element);
            TableImpl.this.setAttribute("rowcount", (Object)this.size(), true);
        }

        @Override
        public Row remove(int index) {
            Row removed = this.rubyArray.remove(index);
            TableImpl.this.setAttribute("rowcount", (Object)this.size(), true);
            return removed;
        }

        @Override
        public int indexOf(Object o) {
            if (!(o instanceof RowImpl)) {
                return -1;
            }
            return this.rubyArray.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            if (!(o instanceof RowImpl)) {
                return -1;
            }
            return this.rubyArray.lastIndexOf(o);
        }
    }
}

