/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.adoc.converter.internal;

import io.github.swagger2markup.adoc.converter.internal.Delimiters;
import io.github.swagger2markup.adoc.converter.internal.ParagraphAttributes;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.asciidoctor.ast.StructuralNode;

public class DelimitedBlockNode
extends ParagraphAttributes {
    public DelimitedBlockNode(StructuralNode node) {
        super(node);
    }

    @Override
    public void processPositionalAttributes() {
        Object source = this.pop(new String[]{"1", "style"});
        StringBuilder options = new StringBuilder();
        ArrayList toRemove = new ArrayList();
        this.attributes.forEach((k, v) -> {
            if (k.endsWith("-option")) {
                toRemove.add(k);
                options.append('%').append(k.replace("-option", ""));
            }
        });
        toRemove.forEach(this.attributes::remove);
        source = (String)source + options.toString();
        if (StringUtils.isNotBlank((CharSequence)source)) {
            this.attrs.add(source);
        }
        super.processPositionalAttributes();
    }

    @Override
    public String processAsciiDocContent() {
        StringBuilder sb = new StringBuilder();
        if (!this.attrs.isEmpty()) {
            sb.append("[").append(String.join((CharSequence)",", this.attrs)).append("]").append(Delimiters.LINE_SEPARATOR);
        }
        return sb.toString();
    }
}

