/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.adoc.converter.internal;

import io.github.swagger2markup.adoc.converter.internal.Delimiters;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;

abstract class NodeAttributes {
    public static final String TITLE = "title";
    final Map<String, Object> attributes;
    List<String> attrs = new ArrayList<String>();

    NodeAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public String pop(String ... keys) {
        AtomicReference<String> value = new AtomicReference<String>("");
        Stream.of(keys).forEach(key -> {
            try {
                String tmpValue = this.attributes.remove(key).toString();
                if (null != tmpValue && !tmpValue.isEmpty() && ((String)value.get()).isEmpty()) {
                    value.set(tmpValue);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
        return value.get();
    }

    String pop(String key) {
        try {
            String value = this.attributes.remove(key).toString();
            if (null == value) {
                value = "";
            }
            return value;
        }
        catch (NullPointerException ignored) {
            return "";
        }
    }

    public final String toAsciiDocContent() {
        this.processPositionalAttributes();
        this.processAttributes();
        return this.processAsciiDocContent();
    }

    abstract void processPositionalAttributes();

    abstract void processAttributes();

    String processAsciiDocContent() {
        StringBuilder sb = new StringBuilder();
        if (!this.attrs.isEmpty()) {
            sb.append("[").append(String.join((CharSequence)",", this.attrs)).append("]").append(Delimiters.LINE_SEPARATOR);
        }
        return sb.toString();
    }
}

