/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.adoc.converter.internal;

import io.github.swagger2markup.adoc.converter.internal.NodeAttributes;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.asciidoctor.ast.StructuralNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParagraphAttributes
extends NodeAttributes {
    public static final String OPTION_SUFFIX = "-option";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public ParagraphAttributes(StructuralNode node) {
        super(node.getAttributes());
    }

    @Override
    public void processPositionalAttributes() {
        String attr1 = this.pop(new String[]{"1", "style"});
        if (StringUtils.isNotBlank((CharSequence)attr1)) {
            this.attrs.add(attr1);
        }
    }

    @Override
    void processAttributes() {
        Object roles;
        Object id = this.pop("id");
        if (StringUtils.isNotBlank((CharSequence)id)) {
            id = "#" + (String)id;
        }
        if (StringUtils.isNotBlank((CharSequence)(roles = String.join((CharSequence)".", this.pop("role").split(" "))))) {
            roles = "." + (String)roles;
        }
        StringBuilder options = new StringBuilder();
        ArrayList namedAttributes = new ArrayList();
        this.attributes.forEach((k, v) -> {
            if (k.equals("title")) {
                this.logger.debug("Skipping attribute: title");
            } else if (k.endsWith(OPTION_SUFFIX)) {
                options.append('%').append(k.replace(OPTION_SUFFIX, ""));
            } else if (null != v) {
                if (v.toString().contains(" ") || v.toString().contains(",")) {
                    namedAttributes.add(k + "=\"" + v + "\"");
                } else {
                    namedAttributes.add(k + "=" + v);
                }
            } else {
                this.logger.warn("Don't know how to handle key: " + k);
            }
        });
        String nonNamedAttributes = (String)id + (String)roles + options.toString();
        if (StringUtils.isNotBlank((CharSequence)nonNamedAttributes)) {
            this.attrs.add(nonNamedAttributes);
        }
        this.attrs.addAll(namedAttributes);
    }
}

