/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.adoc.converter.internal;

import io.github.swagger2markup.adoc.converter.internal.BlockListingNode;
import io.github.swagger2markup.adoc.converter.internal.Delimiters;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.asciidoctor.ast.Block;

public class SourceNode
extends BlockListingNode {
    private List<String> sourceAttrs = new ArrayList<String>();
    private final Block node;

    public SourceNode(Block node) {
        super(node);
        this.node = node;
    }

    @Override
    public void processPositionalAttributes() {
        Object source = this.pop(new String[]{"1", "style"});
        String language = this.pop(new String[]{"2", "language"});
        StringBuilder options = new StringBuilder();
        ArrayList toRemove = new ArrayList();
        this.attributes.forEach((k, v) -> {
            if (k.endsWith("-option")) {
                toRemove.add(k);
                options.append('%').append(k.replace("-option", ""));
            }
        });
        toRemove.forEach(this.attributes::remove);
        source = (String)source + options.toString();
        if (StringUtils.isNotBlank((CharSequence)source)) {
            this.sourceAttrs.add((String)source);
        }
        if (StringUtils.isNotBlank((CharSequence)language)) {
            this.sourceAttrs.add(language);
        }
        super.processPositionalAttributes();
    }

    @Override
    public String processAsciiDocContent() {
        StringBuilder sb = new StringBuilder();
        this.attrsToString(sb, this.attrs);
        this.attrsToString(sb, this.sourceAttrs);
        sb.append(Delimiters.LINE_SEPARATOR).append("----").append(Delimiters.LINE_SEPARATOR).append(this.node.getSource()).append(Delimiters.LINE_SEPARATOR).append("----").append(Delimiters.LINE_SEPARATOR);
        return sb.toString();
    }
}

