/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.extensions;

import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import io.github.swagger2markup.Swagger2MarkupConverter;
import io.github.swagger2markup.extensions.ContentExtension;
import io.github.swagger2markup.markup.builder.MarkupLanguage;
import io.github.swagger2markup.spi.ContentContext;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicContentExtension
extends ContentExtension {
    private static final Logger logger = LoggerFactory.getLogger(DynamicContentExtension.class);

    DynamicContentExtension(Swagger2MarkupConverter.Context globalContext, ContentContext contentContext) {
        super(globalContext, contentContext);
    }

    public void extensionsSection(MarkupLanguage extensionMarkupLanguage, List<Path> contentPaths, String prefix, int levelOffset) {
        Collection filenameExtensions = this.globalContext.getConfig().getMarkupLanguage().getFileNameExtensions().stream().map(fileExtension -> StringUtils.stripStart((String)fileExtension, (String)".")).collect(Collectors.toList());
        DirectoryStream.Filter<Path> filter = entry -> {
            String fileName = entry.getFileName().toString();
            return fileName.startsWith(prefix) && FilenameUtils.isExtension((String)fileName, (Collection)filenameExtensions);
        };
        for (Path currentPath : contentPaths) {
            try {
                DirectoryStream<Path> extensionFiles = Files.newDirectoryStream(currentPath, filter);
                Throwable throwable = null;
                try {
                    if (extensionFiles == null) continue;
                    ArrayList extensions = Lists.newArrayList(extensionFiles);
                    Collections.sort(extensions, Ordering.natural());
                    for (Path extension : extensions) {
                        this.importContent(extension, (Reader reader) -> this.contentContext.getMarkupDocBuilder().importMarkup(reader, extensionMarkupLanguage, levelOffset));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (extensionFiles == null) continue;
                    if (throwable != null) {
                        try {
                            extensionFiles.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    extensionFiles.close();
                }
            }
            catch (IOException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Failed to read extension files from directory {}", (Object)currentPath);
            }
        }
    }
}

