/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.extensions;

import io.github.swagger2markup.Swagger2MarkupConverter;
import io.github.swagger2markup.Swagger2MarkupProperties;
import io.github.swagger2markup.extensions.DynamicContentExtension;
import io.github.swagger2markup.markup.builder.MarkupLanguage;
import io.github.swagger2markup.spi.ContentContext;
import io.github.swagger2markup.spi.DefinitionsDocumentExtension;
import io.github.swagger2markup.utils.IOUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DynamicDefinitionsDocumentExtension
extends DefinitionsDocumentExtension {
    private static final Logger logger = LoggerFactory.getLogger(DynamicDefinitionsDocumentExtension.class);
    protected Path contentPath;
    private static final String PROPERTY_CONTENT_PATH = "contentPath";
    private static final String DEFAULT_EXTENSION_ID = "dynamicDefinitions";
    private static final String PROPERTY_MARKUP_LANGUAGE = "markupLanguage";
    private String extensionId = "dynamicDefinitions";
    private MarkupLanguage extensionMarkupLanguage = MarkupLanguage.ASCIIDOC;

    public DynamicDefinitionsDocumentExtension(Path contentPath, MarkupLanguage extensionMarkupLanguage) {
        this(null, contentPath, extensionMarkupLanguage);
    }

    public DynamicDefinitionsDocumentExtension(String extensionId, Path contentPath, MarkupLanguage extensionMarkupLanguage) {
        Validate.notNull((Object)extensionMarkupLanguage);
        Validate.notNull((Object)contentPath);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{extensionId})) {
            this.extensionId = extensionId;
        }
        this.contentPath = contentPath;
        this.extensionMarkupLanguage = extensionMarkupLanguage;
    }

    public DynamicDefinitionsDocumentExtension() {
    }

    public void init(Swagger2MarkupConverter.Context globalContext) {
        Swagger2MarkupProperties extensionsProperties = globalContext.getConfig().getExtensionsProperties();
        Optional contentPathProperty = extensionsProperties.getPath(this.extensionId + "." + PROPERTY_CONTENT_PATH);
        if (contentPathProperty.isPresent()) {
            this.contentPath = (Path)contentPathProperty.get();
        } else if (this.contentPath == null) {
            if (globalContext.getSwaggerLocation() == null || !globalContext.getSwaggerLocation().getScheme().equals("file")) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Disable DynamicDefinitionsContentExtension > Can't set default contentPath from swaggerLocation. You have to explicitly configure the content path.");
                }
            } else {
                this.contentPath = Paths.get(globalContext.getSwaggerLocation()).getParent();
            }
        }
        Optional extensionMarkupLanguageProperty = extensionsProperties.getMarkupLanguage(this.extensionId + "." + PROPERTY_MARKUP_LANGUAGE);
        if (extensionMarkupLanguageProperty.isPresent()) {
            this.extensionMarkupLanguage = (MarkupLanguage)extensionMarkupLanguageProperty.get();
        }
    }

    public void apply(DefinitionsDocumentExtension.Context context) {
        Validate.notNull((Object)context);
        if (this.contentPath != null) {
            DynamicContentExtension dynamicContent = new DynamicContentExtension(this.globalContext, (ContentContext)context);
            DefinitionsDocumentExtension.Position position = context.getPosition();
            switch (position) {
                case DOCUMENT_BEFORE: 
                case DOCUMENT_AFTER: 
                case DOCUMENT_BEGIN: 
                case DOCUMENT_END: {
                    dynamicContent.extensionsSection(this.extensionMarkupLanguage, this.contentPath, this.contentPrefix(position), this.levelOffset(context));
                    break;
                }
                case DEFINITION_BEFORE: 
                case DEFINITION_BEGIN: 
                case DEFINITION_END: 
                case DEFINITION_AFTER: {
                    dynamicContent.extensionsSection(this.extensionMarkupLanguage, this.contentPath.resolve(Paths.get(IOUtils.normalizeName((String)((String)context.getDefinitionName().get())), new String[0])), this.contentPrefix(position), this.levelOffset(context));
                }
            }
        }
    }

    public String contentPrefix(DefinitionsDocumentExtension.Position position) {
        return position.name().toLowerCase().replace('_', '-');
    }
}

