/*
 * Decompiled with CFR 0.152.
 */
package sylllys.insideout.shell.factories;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import sylllys.insideout.shell.entities.pojo.ShellCommand;
import sylllys.insideout.shell.entities.pojo.ShellScript;
import sylllys.insideout.shell.properties.ShellProperties;

@Component
public class ShellFactory {
    private static final Logger logger = LogManager.getLogger(ShellFactory.class);
    @Autowired
    ShellProperties shellProperties;

    public boolean isThisWindowsOS() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    public String getTerminalProgram() {
        return this.isThisWindowsOS() ? "cmd.exe" : "sh";
    }

    public String getTerminalInterpreter() {
        return this.isThisWindowsOS() ? "/c" : "-c";
    }

    private String captureCommandOutput(Process process) throws IOException {
        return this.readBufferedReader(new BufferedReader(new InputStreamReader(process.getInputStream())));
    }

    private String captureCommandError(Process process) throws IOException {
        return this.readBufferedReader(new BufferedReader(new InputStreamReader(process.getErrorStream())));
    }

    private String readBufferedReader(BufferedReader stdInput) throws IOException {
        String s = null;
        String output = "";
        while ((s = stdInput.readLine()) != null) {
            output = output + s;
        }
        return output;
    }

    private boolean isShellCommandAllowed(String requestedShellCommand) {
        if (this.shellProperties.getAllowedCommands() == null) {
            return false;
        }
        for (String allowedShellCommand : this.shellProperties.getAllowedCommands().split(",")) {
            if (!requestedShellCommand.equalsIgnoreCase(allowedShellCommand.trim())) continue;
            return true;
        }
        return false;
    }

    private boolean isShellScriptAllowed(String requestedShellScript) {
        if (this.shellProperties.getAllowedScripts() == null) {
            return false;
        }
        for (String allowedShellScript : this.shellProperties.getAllowedScripts().split(",")) {
            if (!requestedShellScript.equalsIgnoreCase(allowedShellScript.trim())) continue;
            return true;
        }
        return false;
    }

    private boolean isChainedCommand(String requestedShellCommandLine) {
        String regex = "(?=(?:[^\\\"]*\\\"[^\\\"]*\\\")*[^\\\"]*$)";
        String chainOperators = "&&,&,\\|\\|,\\|,!,>,>>,;";
        for (String chainOperator : "&&,&,\\|\\|,\\|,!,>,>>,;".split(",")) {
            Pattern p = Pattern.compile(chainOperator + "(?=(?:[^\\\"]*\\\"[^\\\"]*\\\")*[^\\\"]*$)");
            Matcher m = p.matcher(requestedShellCommandLine);
            if (!m.find()) continue;
            return false;
        }
        return !requestedShellCommandLine.trim().endsWith("\\");
    }

    private boolean areDoubleQuotesBalanced(String text) {
        int count = StringUtils.countMatches((CharSequence)text, (CharSequence)"\"");
        return count % 2 == 0;
    }

    public void executeCommand(ShellCommand command) {
        if (!this.areDoubleQuotesBalanced(command.getCommand())) {
            command.setError("Double quotes are not balanced.");
            command.setExitCode(3);
            return;
        }
        if (!this.isChainedCommand(command.getCommand())) {
            command.setError("Chained commands are not supported.");
            command.setExitCode(3);
            return;
        }
        if (!this.isShellCommandAllowed(command.getCommand().split(" ", 2)[0])) {
            command.setError("This command is not allowed, please add this to insideout allowed list.");
            command.setExitCode(3);
            return;
        }
        try {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.command(this.getTerminalProgram(), this.getTerminalInterpreter(), command.getCommand());
            Process process = builder.start();
            command.setOutput(this.captureCommandOutput(process));
            command.setError(this.captureCommandError(process));
            command.setExitCode(process.waitFor());
        }
        catch (Exception e) {
            logger.error((Object)e.getStackTrace());
            command.setError("Unhandled error when tried to execute this request");
        }
    }

    public void executeShellScript(ShellScript shellScript) {
        if (!this.isShellScriptAllowed(shellScript.getScriptPath())) {
            shellScript.setError("This script path is not allowed, please add this to insideout allowed list.");
            shellScript.setExitCode(3);
            return;
        }
        if (!new File(shellScript.getScriptPath()).exists()) {
            shellScript.setError("No script exists with this path");
            shellScript.setExitCode(3);
            return;
        }
        try {
            ArrayList<String> command = new ArrayList<String>();
            command.add(shellScript.getScriptPath());
            command.addAll(shellScript.getArgs());
            ProcessBuilder builder = new ProcessBuilder(command);
            Process process = builder.start();
            shellScript.setOutput(this.captureCommandOutput(process));
            shellScript.setError(this.captureCommandError(process));
            shellScript.setExitCode(process.waitFor());
        }
        catch (Exception e) {
            logger.error((Object)e.getStackTrace());
            shellScript.setError("Unhandled error when tried to execute this request");
        }
    }
}

