/*
 * Decompiled with CFR 0.152.
 */
package io.github.t12y.ssim;

import io.github.t12y.ssim.Math;
import io.github.t12y.ssim.matlab.IMFilter;
import io.github.t12y.ssim.matlab.Ones;
import io.github.t12y.ssim.matlab.Skip2d;
import io.github.t12y.ssim.models.Matrix;
import io.github.t12y.ssim.models.Options;
import io.github.t12y.ssim.models.Shape;

public class Downsample {
    private static Matrix imageDownsample(Matrix pixels, Matrix filter, int f) {
        Matrix imdown = IMFilter.imfilter(pixels, filter, Shape.SAME);
        return Skip2d.skip2d(imdown, 0, f, imdown.height, 0, f, imdown.width);
    }

    protected static Matrix[] downsample(Matrix[] pixels, Options options) {
        double factor = (double)java.lang.Math.min(pixels[0].width, pixels[1].height) / (double)options.maxSize;
        int f = (int)java.lang.Math.round(factor);
        if (f > 1) {
            Matrix lpf = Ones.ones(f);
            lpf = Math.divide2d(lpf, Math.sum2d(lpf));
            pixels[0] = Downsample.imageDownsample(pixels[0], lpf, f);
            pixels[1] = Downsample.imageDownsample(pixels[1], lpf, f);
        }
        return new Matrix[]{pixels[0], pixels[1]};
    }
}

