/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import twitter4j.HttpResponse;
import twitter4j.JSONObject;
import twitter4j.ParseUtil;
import twitter4j.RateLimitStatus;
import twitter4j.RateLimitStatusJSONImpl;
import twitter4j.TwitterObjectFactory;
import twitter4j.TwitterResponse;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0013\u001a\u00020\rH\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u000fH\u0016J \u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\u0017\u001a\u00020\u0007H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Ltwitter4j/BooleanResponse;", "Ltwitter4j/TwitterResponse;", "res", "Ltwitter4j/HttpResponse;", "isJSONStoreEnabled", "", "key", "", "(Ltwitter4j/HttpResponse;ZLjava/lang/String;)V", "json", "Ltwitter4j/JSONObject;", "(Ltwitter4j/JSONObject;ZLjava/lang/String;)V", "accessLevel", "", "rateLimitStatus", "Ltwitter4j/RateLimitStatus;", "result", "getResult", "()Z", "getAccessLevel", "getRateLimitStatus", "parse", "jsonObject", "toString", "twitter4j-v2-support"})
public final class BooleanResponse
implements TwitterResponse {
    @Nullable
    private transient RateLimitStatus rateLimitStatus;
    private transient int accessLevel;
    private final boolean result;

    public final boolean getResult() {
        return this.result;
    }

    public BooleanResponse(@NotNull HttpResponse res, boolean isJSONStoreEnabled, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.rateLimitStatus = RateLimitStatusJSONImpl.createFromResponseHeader((HttpResponse)res);
        this.accessLevel = ParseUtil.toAccessLevel((HttpResponse)res);
        JSONObject jSONObject = res.asJSONObject();
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"res.asJSONObject()");
        this.result = this.parse(jSONObject, isJSONStoreEnabled, key);
    }

    public BooleanResponse(@NotNull JSONObject json, boolean isJSONStoreEnabled, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.result = this.parse(json, isJSONStoreEnabled, key);
    }

    private final boolean parse(JSONObject jsonObject, boolean isJSONStoreEnabled, String key) {
        if (isJSONStoreEnabled) {
            TwitterObjectFactory.registerJSONObject((Object)this, (Object)jsonObject);
        }
        return jsonObject.getJSONObject("data").getBoolean(key);
    }

    @Nullable
    public RateLimitStatus getRateLimitStatus() {
        return this.rateLimitStatus;
    }

    public int getAccessLevel() {
        return this.accessLevel;
    }

    @NotNull
    public String toString() {
        return "BooleanResponse(rateLimitStatus=" + this.rateLimitStatus + ", accessLevel=" + this.accessLevel + ", result=" + this.result + ')';
    }
}

