/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import twitter4j.HttpResponse;
import twitter4j.JSONArray;
import twitter4j.JSONObject;
import twitter4j.ParseUtil;
import twitter4j.RateLimitStatus;
import twitter4j.RateLimitStatusJSONImpl;
import twitter4j.TwitterObjectFactory;
import twitter4j.TwitterResponse;
import twitter4j.V2Util;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0018\u001a\u00020\u000bH\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0012H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006 "}, d2={"Ltwitter4j/CountsResponse;", "Ltwitter4j/TwitterResponse;", "res", "Ltwitter4j/HttpResponse;", "isJSONStoreEnabled", "", "(Ltwitter4j/HttpResponse;Z)V", "json", "Ltwitter4j/JSONObject;", "(Ltwitter4j/JSONObject;Z)V", "accessLevel", "", "counts", "", "Ltwitter4j/CountsResponse$Count;", "getCounts", "()Ljava/util/List;", "rateLimitStatus", "Ltwitter4j/RateLimitStatus;", "totalTweetCount", "getTotalTweetCount", "()I", "setTotalTweetCount", "(I)V", "getAccessLevel", "getRateLimitStatus", "parse", "", "jsonObject", "toString", "", "Count", "twitter4j-v2-support"})
public final class CountsResponse
implements TwitterResponse {
    @Nullable
    private transient RateLimitStatus rateLimitStatus;
    private transient int accessLevel;
    @NotNull
    private final List<Count> counts;
    private int totalTweetCount;

    @NotNull
    public final List<Count> getCounts() {
        return this.counts;
    }

    public final int getTotalTweetCount() {
        return this.totalTweetCount;
    }

    public final void setTotalTweetCount(int n) {
        this.totalTweetCount = n;
    }

    public CountsResponse(@NotNull HttpResponse res, boolean isJSONStoreEnabled) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        this.counts = new ArrayList();
        this.rateLimitStatus = RateLimitStatusJSONImpl.createFromResponseHeader((HttpResponse)res);
        this.accessLevel = ParseUtil.toAccessLevel((HttpResponse)res);
        JSONObject jSONObject = res.asJSONObject();
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"res.asJSONObject()");
        this.parse(jSONObject, isJSONStoreEnabled);
    }

    public CountsResponse(@NotNull JSONObject json, boolean isJSONStoreEnabled) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.counts = new ArrayList();
        this.parse(json, isJSONStoreEnabled);
    }

    public /* synthetic */ CountsResponse(JSONObject jSONObject, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(jSONObject, bl);
    }

    private final void parse(JSONObject jsonObject, boolean isJSONStoreEnabled) {
        List<Count> list = this.counts;
        Intrinsics.checkNotNull(list, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<twitter4j.CountsResponse.Count>");
        List counts = TypeIntrinsics.asMutableList(list);
        counts.clear();
        JSONArray dataArray = jsonObject.optJSONArray("data");
        if (dataArray != null) {
            int n = dataArray.length();
            for (int i = 0; i < n; ++i) {
                JSONObject data = dataArray.getJSONObject(i);
                Date date = V2Util.INSTANCE.parseISO8601Date("end", data);
                Intrinsics.checkNotNull((Object)date);
                Date date2 = V2Util.INSTANCE.parseISO8601Date("start", data);
                Intrinsics.checkNotNull((Object)date2);
                counts.add(new Count(date, date2, data.getInt("tweet_count")));
            }
        }
        this.totalTweetCount = jsonObject.getJSONObject("meta").getInt("total_tweet_count");
        if (isJSONStoreEnabled) {
            TwitterObjectFactory.registerJSONObject((Object)this, (Object)jsonObject);
        }
    }

    @Nullable
    public RateLimitStatus getRateLimitStatus() {
        return this.rateLimitStatus;
    }

    public int getAccessLevel() {
        return this.accessLevel;
    }

    @NotNull
    public String toString() {
        return "CountsResponse(rateLimitStatus=" + this.rateLimitStatus + ", accessLevel=" + this.accessLevel + ", counts=" + this.counts + ", totalTweetCount=" + this.totalTweetCount + ')';
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Ltwitter4j/CountsResponse$Count;", "", "end", "Ljava/util/Date;", "start", "tweetCount", "", "(Ljava/util/Date;Ljava/util/Date;I)V", "getEnd", "()Ljava/util/Date;", "getStart", "getTweetCount", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "twitter4j-v2-support"})
    public static final class Count {
        @NotNull
        private final Date end;
        @NotNull
        private final Date start;
        private final int tweetCount;

        public Count(@NotNull Date end, @NotNull Date start, int tweetCount) {
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            this.end = end;
            this.start = start;
            this.tweetCount = tweetCount;
        }

        @NotNull
        public final Date getEnd() {
            return this.end;
        }

        @NotNull
        public final Date getStart() {
            return this.start;
        }

        public final int getTweetCount() {
            return this.tweetCount;
        }

        @NotNull
        public final Date component1() {
            return this.end;
        }

        @NotNull
        public final Date component2() {
            return this.start;
        }

        public final int component3() {
            return this.tweetCount;
        }

        @NotNull
        public final Count copy(@NotNull Date end, @NotNull Date start, int tweetCount) {
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            return new Count(end, start, tweetCount);
        }

        public static /* synthetic */ Count copy$default(Count count, Date date, Date date2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                date = count.end;
            }
            if ((n2 & 2) != 0) {
                date2 = count.start;
            }
            if ((n2 & 4) != 0) {
                n = count.tweetCount;
            }
            return count.copy(date, date2, n);
        }

        @NotNull
        public String toString() {
            return "Count(end=" + this.end + ", start=" + this.start + ", tweetCount=" + this.tweetCount + ')';
        }

        public int hashCode() {
            int result = this.end.hashCode();
            result = result * 31 + this.start.hashCode();
            result = result * 31 + Integer.hashCode(this.tweetCount);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Count)) {
                return false;
            }
            Count count = (Count)other;
            if (!Intrinsics.areEqual((Object)this.end, (Object)count.end)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.start, (Object)count.start)) {
                return false;
            }
            return this.tweetCount == count.tweetCount;
        }
    }
}

