/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import twitter4j.HttpResponse;
import twitter4j.JSONObject;
import twitter4j.ParseUtil;
import twitter4j.RateLimitStatus;
import twitter4j.RateLimitStatusJSONImpl;
import twitter4j.TwitterObjectFactory;
import twitter4j.TwitterResponse;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0016\u001a\u00020\u000bH\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0011H\u0016J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u001a\u001a\u00020\u0013H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001b"}, d2={"Ltwitter4j/CreateTweetResponse;", "Ltwitter4j/TwitterResponse;", "res", "Ltwitter4j/HttpResponse;", "isJSONStoreEnabled", "", "(Ltwitter4j/HttpResponse;Z)V", "json", "Ltwitter4j/JSONObject;", "(Ltwitter4j/JSONObject;Z)V", "accessLevel", "", "id", "", "getId", "()J", "rateLimitStatus", "Ltwitter4j/RateLimitStatus;", "text", "", "getText", "()Ljava/lang/String;", "getAccessLevel", "getRateLimitStatus", "parse", "jsonObject", "toString", "twitter4j-v2-support"})
public final class CreateTweetResponse
implements TwitterResponse {
    @Nullable
    private transient RateLimitStatus rateLimitStatus;
    private transient int accessLevel;
    private final long id;
    @NotNull
    private final String text;

    public final long getId() {
        return this.id;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public CreateTweetResponse(@NotNull HttpResponse res, boolean isJSONStoreEnabled) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        this.rateLimitStatus = RateLimitStatusJSONImpl.createFromResponseHeader((HttpResponse)res);
        this.accessLevel = ParseUtil.toAccessLevel((HttpResponse)res);
        JSONObject jSONObject = res.asJSONObject();
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"res.asJSONObject()");
        JSONObject dataJson = this.parse(jSONObject, isJSONStoreEnabled);
        this.id = dataJson.getLong("id");
        String string = dataJson.getString("text");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dataJson.getString(\"text\")");
        this.text = string;
    }

    public CreateTweetResponse(@NotNull JSONObject json, boolean isJSONStoreEnabled) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        JSONObject dataJson = this.parse(json, isJSONStoreEnabled);
        this.id = dataJson.getLong("id");
        String string = dataJson.getString("text");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dataJson.getString(\"text\")");
        this.text = string;
    }

    private final JSONObject parse(JSONObject jsonObject, boolean isJSONStoreEnabled) {
        if (isJSONStoreEnabled) {
            TwitterObjectFactory.registerJSONObject((Object)this, (Object)jsonObject);
        }
        JSONObject jSONObject = jsonObject.getJSONObject("data");
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"jsonObject.getJSONObject(\"data\")");
        return jSONObject;
    }

    @Nullable
    public RateLimitStatus getRateLimitStatus() {
        return this.rateLimitStatus;
    }

    public int getAccessLevel() {
        return this.accessLevel;
    }

    @NotNull
    public String toString() {
        return "CreateTweetResponse(rateLimitStatus=" + this.rateLimitStatus + ", accessLevel=" + this.accessLevel + ", id=" + this.id + ", text='" + this.text + "')";
    }
}

