/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.ArrayList;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import twitter4j.HttpResponse;
import twitter4j.JSONArray;
import twitter4j.JSONObject;
import twitter4j.JSONObjectExKt;
import twitter4j.ParseUtil;
import twitter4j.RateLimitStatus;
import twitter4j.RateLimitStatusJSONImpl;
import twitter4j.TwitterList;
import twitter4j.TwitterObjectFactory;
import twitter4j.TwitterResponse;
import twitter4j.User2;
import twitter4j.V2Util;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001a\u001a\u00020\u000bH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0012H\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\bH\u0002J\b\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R-\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014j\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016`\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006#"}, d2={"Ltwitter4j/ListsResponse;", "Ltwitter4j/TwitterResponse;", "res", "Ltwitter4j/HttpResponse;", "isJSONStoreEnabled", "", "(Ltwitter4j/HttpResponse;Z)V", "json", "Ltwitter4j/JSONObject;", "(Ltwitter4j/JSONObject;Z)V", "accessLevel", "", "lists", "Ljava/util/ArrayList;", "Ltwitter4j/TwitterList;", "getLists", "()Ljava/util/ArrayList;", "rateLimitStatus", "Ltwitter4j/RateLimitStatus;", "usersMap", "Ljava/util/HashMap;", "", "Ltwitter4j/User2;", "Lkotlin/collections/HashMap;", "getUsersMap", "()Ljava/util/HashMap;", "getAccessLevel", "getRateLimitStatus", "parse", "", "jsonObject", "parseTwitterList", "data", "toString", "", "twitter4j-v2-support"})
public final class ListsResponse
implements TwitterResponse {
    @Nullable
    private transient RateLimitStatus rateLimitStatus;
    private transient int accessLevel;
    @NotNull
    private final ArrayList<TwitterList> lists;
    @NotNull
    private final HashMap<Long, User2> usersMap;

    @NotNull
    public final ArrayList<TwitterList> getLists() {
        return this.lists;
    }

    @NotNull
    public final HashMap<Long, User2> getUsersMap() {
        return this.usersMap;
    }

    public ListsResponse(@NotNull HttpResponse res, boolean isJSONStoreEnabled) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        this.lists = new ArrayList();
        this.usersMap = new HashMap();
        this.rateLimitStatus = RateLimitStatusJSONImpl.createFromResponseHeader((HttpResponse)res);
        this.accessLevel = ParseUtil.toAccessLevel((HttpResponse)res);
        JSONObject jSONObject = res.asJSONObject();
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"res.asJSONObject()");
        this.parse(jSONObject, isJSONStoreEnabled);
    }

    public ListsResponse(@NotNull JSONObject json, boolean isJSONStoreEnabled) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.lists = new ArrayList();
        this.usersMap = new HashMap();
        this.parse(json, isJSONStoreEnabled);
    }

    private final void parse(JSONObject jsonObject, boolean isJSONStoreEnabled) {
        if (isJSONStoreEnabled) {
            TwitterObjectFactory.registerJSONObject((Object)this, (Object)jsonObject);
        }
        JSONObject includes = jsonObject.optJSONObject("includes");
        V2Util.INSTANCE.collectUsers(includes, this.usersMap);
        Object data = jsonObject.opt("data");
        if (data instanceof JSONObject) {
            this.lists.add(this.parseTwitterList((JSONObject)data));
        } else if (data instanceof JSONArray) {
            int n = ((JSONArray)data).length();
            for (int i = 0; i < n; ++i) {
                JSONObject entry = ((JSONArray)data).getJSONObject(i);
                Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"entry");
                this.lists.add(this.parseTwitterList(entry));
            }
        }
    }

    private final TwitterList parseTwitterList(JSONObject data) {
        long l = data.getLong("id");
        String string = data.getString("name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"data.getString(\"name\")");
        return new TwitterList(l, string, JSONObjectExKt.optLongOrNull(data, "owner_id"), V2Util.INSTANCE.parseISO8601Date("created_at", data), JSONObjectExKt.optIntOrNull(data, "follower_count"), JSONObjectExKt.optIntOrNull(data, "member_count"), JSONObjectExKt.optBooleanOrNull(data, "private"), data.optString("description", null));
    }

    @Nullable
    public RateLimitStatus getRateLimitStatus() {
        return this.rateLimitStatus;
    }

    public int getAccessLevel() {
        return this.accessLevel;
    }

    @NotNull
    public String toString() {
        return "ListsResponse(rateLimitStatus=" + this.rateLimitStatus + ", accessLevel=" + this.accessLevel + ", lists=" + this.lists + ", usersMap=" + this.usersMap + ')';
    }
}

