/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import twitter4j.HttpClient;
import twitter4j.HttpClientConfiguration;
import twitter4j.HttpClientFactory;
import twitter4j.HttpParameter;
import twitter4j.HttpResponse;
import twitter4j.JSONObject;
import twitter4j.TwitterException;
import twitter4j.auth.Authorization;
import twitter4j.auth.OAuth2Authorization;
import twitter4j.conf.Configuration;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J3\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\b\b\u0002\u0010\u000e\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000fJ*\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\b\b\u0002\u0010\u000e\u001a\u00020\tJ\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ltwitter4j/OAuth2TokenProvider;", "", "conf", "Ltwitter4j/conf/Configuration;", "(Ltwitter4j/conf/Configuration;)V", "http", "Ltwitter4j/HttpClient;", "kotlin.jvm.PlatformType", "createAuthorizeUrl", "", "clientId", "redirectUri", "scopes", "", "challenge", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "getAccessToken", "Ltwitter4j/OAuth2TokenProvider$Result;", "code", "refreshToken", "Result", "twitter4j-v2-support"})
public final class OAuth2TokenProvider {
    @NotNull
    private final Configuration conf;
    private final HttpClient http;

    public OAuth2TokenProvider(@NotNull Configuration conf2) {
        Intrinsics.checkNotNullParameter((Object)conf2, (String)"conf");
        this.conf = conf2;
        this.http = HttpClientFactory.getInstance((HttpClientConfiguration)this.conf.getHttpClientConfiguration());
    }

    @NotNull
    public final String createAuthorizeUrl(@NotNull String clientId2, @NotNull String redirectUri2, @NotNull String[] scopes, @NotNull String challenge) {
        Intrinsics.checkNotNullParameter((Object)clientId2, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)redirectUri2, (String)"redirectUri");
        Intrinsics.checkNotNullParameter((Object)scopes, (String)"scopes");
        Intrinsics.checkNotNullParameter((Object)challenge, (String)"challenge");
        String scope = ArraysKt.joinToString$default((Object[])scopes, (CharSequence)"%20", null, null, (int)0, null, null, (int)62, null);
        return "https://twitter.com/i/oauth2/authorize?response_type=code&client_id=" + clientId2 + "&redirect_uri=" + redirectUri2 + "&scope=" + scope + "&state=state&code_challenge=" + challenge + "&code_challenge_method=plain";
    }

    public static /* synthetic */ String createAuthorizeUrl$default(OAuth2TokenProvider oAuth2TokenProvider, String string, String string2, String[] stringArray, String string3, int n, Object object) {
        if ((n & 8) != 0) {
            string3 = "challenge";
        }
        return oAuth2TokenProvider.createAuthorizeUrl(string, string2, stringArray, string3);
    }

    @Nullable
    public final Result getAccessToken(@NotNull String clientId2, @NotNull String redirectUri2, @NotNull String code, @NotNull String challenge) {
        Intrinsics.checkNotNullParameter((Object)clientId2, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)redirectUri2, (String)"redirectUri");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)challenge, (String)"challenge");
        OAuth2Authorization oauth2 = new OAuth2Authorization(this.conf);
        HttpParameter[] httpParameterArray = new HttpParameter[]{new HttpParameter("code", code), new HttpParameter("grant_type", "authorization_code"), new HttpParameter("client_id", clientId2), new HttpParameter("redirect_uri", redirectUri2), new HttpParameter("code_verifier", challenge)};
        HttpParameter[] params = httpParameterArray;
        HttpResponse httpResponse = this.http.post("https://api.twitter.com/2/oauth2/token", params, (Authorization)oauth2, null);
        Intrinsics.checkNotNullExpressionValue((Object)httpResponse, (String)"http.post(\"https://api.t\u2026n\", params, oauth2, null)");
        HttpResponse res = httpResponse;
        if (res.getStatusCode() != 200) {
            throw new TwitterException("Obtaining OAuth 2 Bearer Token failed.", res);
        }
        JSONObject jSONObject = res.asJSONObject();
        if (jSONObject == null) {
            return null;
        }
        JSONObject json = jSONObject;
        String string = json.getString("token_type");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"json.getString(\"token_type\")");
        long l = json.getLong("expires_in");
        String string2 = json.getString("access_token");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"json.getString(\"access_token\")");
        String string3 = json.getString("scope");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"json.getString(\"scope\")");
        String string4 = json.getString("refresh_token");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"json.getString(\"refresh_token\")");
        return new Result(string, l, string2, string3, string4);
    }

    public static /* synthetic */ Result getAccessToken$default(OAuth2TokenProvider oAuth2TokenProvider, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 8) != 0) {
            string4 = "challenge";
        }
        return oAuth2TokenProvider.getAccessToken(string, string2, string3, string4);
    }

    @Nullable
    public final Result refreshToken(@NotNull String clientId2, @NotNull String refreshToken) {
        Intrinsics.checkNotNullParameter((Object)clientId2, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)refreshToken, (String)"refreshToken");
        OAuth2Authorization oauth2 = new OAuth2Authorization(this.conf);
        HttpParameter[] httpParameterArray = new HttpParameter[]{new HttpParameter("grant_type", "refresh_token"), new HttpParameter("refresh_token", refreshToken), new HttpParameter("client_id", clientId2)};
        HttpParameter[] params = httpParameterArray;
        HttpResponse httpResponse = this.http.post("https://api.twitter.com/2/oauth2/token", params, (Authorization)oauth2, null);
        Intrinsics.checkNotNullExpressionValue((Object)httpResponse, (String)"http.post(\"https://api.t\u2026n\", params, oauth2, null)");
        HttpResponse res = httpResponse;
        if (res.getStatusCode() != 200) {
            throw new TwitterException("Obtaining OAuth 2 Bearer Token failed.", res);
        }
        JSONObject jSONObject = res.asJSONObject();
        if (jSONObject == null) {
            return null;
        }
        JSONObject json = jSONObject;
        String string = json.getString("token_type");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"json.getString(\"token_type\")");
        long l = json.getLong("expires_in");
        String string2 = json.getString("access_token");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"json.getString(\"access_token\")");
        String string3 = json.getString("scope");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"json.getString(\"scope\")");
        String string4 = json.getString("refresh_token");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"json.getString(\"refresh_token\")");
        return new Result(string, l, string2, string3, string4);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J;\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001d"}, d2={"Ltwitter4j/OAuth2TokenProvider$Result;", "", "tokenType", "", "expiresIn", "", "accessToken", "scope", "refreshToken", "(Ljava/lang/String;JLjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAccessToken", "()Ljava/lang/String;", "getExpiresIn", "()J", "getRefreshToken", "getScope", "getTokenType", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "twitter4j-v2-support"})
    public static final class Result {
        @NotNull
        private final String tokenType;
        private final long expiresIn;
        @NotNull
        private final String accessToken;
        @NotNull
        private final String scope;
        @NotNull
        private final String refreshToken;

        public Result(@NotNull String tokenType, long expiresIn, @NotNull String accessToken, @NotNull String scope, @NotNull String refreshToken) {
            Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)refreshToken, (String)"refreshToken");
            this.tokenType = tokenType;
            this.expiresIn = expiresIn;
            this.accessToken = accessToken;
            this.scope = scope;
            this.refreshToken = refreshToken;
        }

        @NotNull
        public final String getTokenType() {
            return this.tokenType;
        }

        public final long getExpiresIn() {
            return this.expiresIn;
        }

        @NotNull
        public final String getAccessToken() {
            return this.accessToken;
        }

        @NotNull
        public final String getScope() {
            return this.scope;
        }

        @NotNull
        public final String getRefreshToken() {
            return this.refreshToken;
        }

        @NotNull
        public final String component1() {
            return this.tokenType;
        }

        public final long component2() {
            return this.expiresIn;
        }

        @NotNull
        public final String component3() {
            return this.accessToken;
        }

        @NotNull
        public final String component4() {
            return this.scope;
        }

        @NotNull
        public final String component5() {
            return this.refreshToken;
        }

        @NotNull
        public final Result copy(@NotNull String tokenType, long expiresIn, @NotNull String accessToken, @NotNull String scope, @NotNull String refreshToken) {
            Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)refreshToken, (String)"refreshToken");
            return new Result(tokenType, expiresIn, accessToken, scope, refreshToken);
        }

        public static /* synthetic */ Result copy$default(Result result, String string, long l, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = result.tokenType;
            }
            if ((n & 2) != 0) {
                l = result.expiresIn;
            }
            if ((n & 4) != 0) {
                string2 = result.accessToken;
            }
            if ((n & 8) != 0) {
                string3 = result.scope;
            }
            if ((n & 0x10) != 0) {
                string4 = result.refreshToken;
            }
            return result.copy(string, l, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "Result(tokenType=" + this.tokenType + ", expiresIn=" + this.expiresIn + ", accessToken=" + this.accessToken + ", scope=" + this.scope + ", refreshToken=" + this.refreshToken + ')';
        }

        public int hashCode() {
            int result = this.tokenType.hashCode();
            result = result * 31 + Long.hashCode(this.expiresIn);
            result = result * 31 + this.accessToken.hashCode();
            result = result * 31 + this.scope.hashCode();
            result = result * 31 + this.refreshToken.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result = (Result)other;
            if (!Intrinsics.areEqual((Object)this.tokenType, (Object)result.tokenType)) {
                return false;
            }
            if (this.expiresIn != result.expiresIn) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.accessToken, (Object)result.accessToken)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.scope, (Object)result.scope)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.refreshToken, (Object)result.refreshToken);
        }
    }
}

