/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import twitter4j.ErrorInfo;
import twitter4j.HttpResponse;
import twitter4j.JSONArray;
import twitter4j.JSONObject;
import twitter4j.Media;
import twitter4j.MediaKey;
import twitter4j.Meta;
import twitter4j.ParseUtil;
import twitter4j.Place2;
import twitter4j.Poll;
import twitter4j.RateLimitStatus;
import twitter4j.RateLimitStatusJSONImpl;
import twitter4j.Tweet;
import twitter4j.TwitterObjectFactory;
import twitter4j.TwitterResponse;
import twitter4j.User2;
import twitter4j.V2Util;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\b\u00100\u001a\u00020\u000bH\u0016J\n\u00101\u001a\u0004\u0018\u00010'H\u0016J\u0018\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u00105\u001a\u00020\u001fH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R-\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012j\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014`\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR-\u0010\u001e\u001a\u001e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u0012j\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 `\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0017R-\u0010\"\u001a\u001e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\u0012j\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$`\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0017R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0010R-\u0010+\u001a\u001e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020)0\u0012j\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020)`\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0017R-\u0010-\u001a\u001e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020.0\u0012j\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020.`\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u0017\u00a8\u00066"}, d2={"Ltwitter4j/TweetsResponse;", "Ltwitter4j/TwitterResponse;", "res", "Ltwitter4j/HttpResponse;", "isJSONStoreEnabled", "", "(Ltwitter4j/HttpResponse;Z)V", "json", "Ltwitter4j/JSONObject;", "(Ltwitter4j/JSONObject;Z)V", "accessLevel", "", "errors", "", "Ltwitter4j/ErrorInfo;", "getErrors", "()Ljava/util/List;", "mediaMap", "Ljava/util/HashMap;", "Ltwitter4j/MediaKey;", "Ltwitter4j/Media;", "Lkotlin/collections/HashMap;", "getMediaMap", "()Ljava/util/HashMap;", "meta", "Ltwitter4j/Meta;", "getMeta", "()Ltwitter4j/Meta;", "setMeta", "(Ltwitter4j/Meta;)V", "placesMap", "", "Ltwitter4j/Place2;", "getPlacesMap", "pollsMap", "", "Ltwitter4j/Poll;", "getPollsMap", "rateLimitStatus", "Ltwitter4j/RateLimitStatus;", "tweets", "Ltwitter4j/Tweet;", "getTweets", "tweetsMap", "getTweetsMap", "usersMap", "Ltwitter4j/User2;", "getUsersMap", "getAccessLevel", "getRateLimitStatus", "parse", "", "jsonObject", "toString", "twitter4j-v2-support"})
public final class TweetsResponse
implements TwitterResponse {
    @Nullable
    private transient RateLimitStatus rateLimitStatus;
    private transient int accessLevel;
    @NotNull
    private final List<Tweet> tweets;
    @NotNull
    private final HashMap<Long, Poll> pollsMap;
    @NotNull
    private final HashMap<MediaKey, Media> mediaMap;
    @NotNull
    private final HashMap<Long, User2> usersMap;
    @NotNull
    private final HashMap<Long, Tweet> tweetsMap;
    @NotNull
    private final HashMap<String, Place2> placesMap;
    @Nullable
    private Meta meta;
    @NotNull
    private final List<ErrorInfo> errors;

    @NotNull
    public final List<Tweet> getTweets() {
        return this.tweets;
    }

    @NotNull
    public final HashMap<Long, Poll> getPollsMap() {
        return this.pollsMap;
    }

    @NotNull
    public final HashMap<MediaKey, Media> getMediaMap() {
        return this.mediaMap;
    }

    @NotNull
    public final HashMap<Long, User2> getUsersMap() {
        return this.usersMap;
    }

    @NotNull
    public final HashMap<Long, Tweet> getTweetsMap() {
        return this.tweetsMap;
    }

    @NotNull
    public final HashMap<String, Place2> getPlacesMap() {
        return this.placesMap;
    }

    @Nullable
    public final Meta getMeta() {
        return this.meta;
    }

    public final void setMeta(@Nullable Meta meta) {
        this.meta = meta;
    }

    @NotNull
    public final List<ErrorInfo> getErrors() {
        return this.errors;
    }

    public TweetsResponse(@NotNull HttpResponse res, boolean isJSONStoreEnabled) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        this.tweets = new ArrayList();
        this.pollsMap = new HashMap();
        this.mediaMap = new HashMap();
        this.usersMap = new HashMap();
        this.tweetsMap = new HashMap();
        this.placesMap = new HashMap();
        this.errors = new ArrayList();
        this.rateLimitStatus = RateLimitStatusJSONImpl.createFromResponseHeader((HttpResponse)res);
        this.accessLevel = ParseUtil.toAccessLevel((HttpResponse)res);
        JSONObject jSONObject = res.asJSONObject();
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"res.asJSONObject()");
        this.parse(jSONObject, isJSONStoreEnabled);
    }

    public TweetsResponse(@NotNull JSONObject json, boolean isJSONStoreEnabled) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.tweets = new ArrayList();
        this.pollsMap = new HashMap();
        this.mediaMap = new HashMap();
        this.usersMap = new HashMap();
        this.tweetsMap = new HashMap();
        this.placesMap = new HashMap();
        this.errors = new ArrayList();
        this.parse(json, isJSONStoreEnabled);
    }

    public /* synthetic */ TweetsResponse(JSONObject jSONObject, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(jSONObject, bl);
    }

    private final void parse(JSONObject jsonObject, boolean isJSONStoreEnabled) {
        List<Tweet> list = this.tweets;
        Intrinsics.checkNotNull(list, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<twitter4j.Tweet>");
        List tweets = TypeIntrinsics.asMutableList(list);
        tweets.clear();
        JSONObject includes = jsonObject.optJSONObject("includes");
        V2Util.INSTANCE.collectPolls(includes, this.pollsMap);
        V2Util.INSTANCE.collectUsers(includes, this.usersMap);
        V2Util.INSTANCE.collectPlaces(includes, this.placesMap);
        V2Util.INSTANCE.collectTweets(includes, this.tweetsMap);
        V2Util.INSTANCE.collectMediaKeys(includes, this.mediaMap);
        JSONArray dataArray = jsonObject.optJSONArray("data");
        if (dataArray != null) {
            int n = dataArray.length();
            for (int i = 0; i < n; ++i) {
                JSONObject data = dataArray.getJSONObject(i);
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                tweets.add(Tweet.Companion.parse(data));
            }
        }
        this.meta = V2Util.INSTANCE.parseMeta(jsonObject);
        V2Util.INSTANCE.collectErrors(jsonObject, this.errors);
        if (isJSONStoreEnabled) {
            TwitterObjectFactory.registerJSONObject((Object)this, (Object)jsonObject);
        }
    }

    @Nullable
    public RateLimitStatus getRateLimitStatus() {
        return this.rateLimitStatus;
    }

    public int getAccessLevel() {
        return this.accessLevel;
    }

    @NotNull
    public String toString() {
        return "TweetsResponse(rateLimitStatus=" + this.rateLimitStatus + ", accessLevel=" + this.accessLevel + ", tweets=" + this.tweets + ", pollsMap=" + this.pollsMap + ", mediaMap=" + this.mediaMap + ", usersMap=" + this.usersMap + ", tweetsMap=" + this.tweetsMap + ", placesMap=" + this.placesMap + ", meta=" + this.meta + ", errors=" + this.errors + ')';
    }
}

