/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import twitter4j.HttpResponse;
import twitter4j.JSONArray;
import twitter4j.JSONObject;
import twitter4j.Meta;
import twitter4j.ParseUtil;
import twitter4j.Place2;
import twitter4j.Poll;
import twitter4j.RateLimitStatus;
import twitter4j.RateLimitStatusJSONImpl;
import twitter4j.Tweet;
import twitter4j.TwitterObjectFactory;
import twitter4j.TwitterResponse;
import twitter4j.User2;
import twitter4j.V2Util;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\b\u0010)\u001a\u00020\u000bH\u0016J\n\u0010*\u001a\u0004\u0018\u00010\u001eH\u0016J\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010.\u001a\u00020\u0014H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R-\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013j\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0015`\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R-\u0010\u0019\u001a\u001e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0013j\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b`\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0018R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R-\u0010\u001f\u001a\u001e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020 0\u0013j\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020 `\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0018R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R-\u0010'\u001a\u001e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020$0\u0013j\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020$`\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0018\u00a8\u0006/"}, d2={"Ltwitter4j/UsersResponse;", "Ltwitter4j/TwitterResponse;", "res", "Ltwitter4j/HttpResponse;", "isJSONStoreEnabled", "", "(Ltwitter4j/HttpResponse;Z)V", "json", "Ltwitter4j/JSONObject;", "(Ltwitter4j/JSONObject;Z)V", "accessLevel", "", "meta", "Ltwitter4j/Meta;", "getMeta", "()Ltwitter4j/Meta;", "setMeta", "(Ltwitter4j/Meta;)V", "placesMap", "Ljava/util/HashMap;", "", "Ltwitter4j/Place2;", "Lkotlin/collections/HashMap;", "getPlacesMap", "()Ljava/util/HashMap;", "pollsMap", "", "Ltwitter4j/Poll;", "getPollsMap", "rateLimitStatus", "Ltwitter4j/RateLimitStatus;", "tweetsMap", "Ltwitter4j/Tweet;", "getTweetsMap", "users", "", "Ltwitter4j/User2;", "getUsers", "()Ljava/util/List;", "usersMap", "getUsersMap", "getAccessLevel", "getRateLimitStatus", "parse", "", "jsonObject", "toString", "twitter4j-v2-support"})
public final class UsersResponse
implements TwitterResponse {
    @Nullable
    private transient RateLimitStatus rateLimitStatus;
    private transient int accessLevel;
    @NotNull
    private final List<User2> users;
    @NotNull
    private final HashMap<Long, Poll> pollsMap;
    @NotNull
    private final HashMap<Long, User2> usersMap;
    @NotNull
    private final HashMap<String, Place2> placesMap;
    @NotNull
    private final HashMap<Long, Tweet> tweetsMap;
    @Nullable
    private Meta meta;

    @NotNull
    public final List<User2> getUsers() {
        return this.users;
    }

    @NotNull
    public final HashMap<Long, Poll> getPollsMap() {
        return this.pollsMap;
    }

    @NotNull
    public final HashMap<Long, User2> getUsersMap() {
        return this.usersMap;
    }

    @NotNull
    public final HashMap<String, Place2> getPlacesMap() {
        return this.placesMap;
    }

    @NotNull
    public final HashMap<Long, Tweet> getTweetsMap() {
        return this.tweetsMap;
    }

    @Nullable
    public final Meta getMeta() {
        return this.meta;
    }

    public final void setMeta(@Nullable Meta meta) {
        this.meta = meta;
    }

    public UsersResponse(@NotNull HttpResponse res, boolean isJSONStoreEnabled) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        this.users = new ArrayList();
        this.pollsMap = new HashMap();
        this.usersMap = new HashMap();
        this.placesMap = new HashMap();
        this.tweetsMap = new HashMap();
        this.rateLimitStatus = RateLimitStatusJSONImpl.createFromResponseHeader((HttpResponse)res);
        this.accessLevel = ParseUtil.toAccessLevel((HttpResponse)res);
        JSONObject jSONObject = res.asJSONObject();
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"res.asJSONObject()");
        this.parse(jSONObject, isJSONStoreEnabled);
    }

    public UsersResponse(@NotNull JSONObject json, boolean isJSONStoreEnabled) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.users = new ArrayList();
        this.pollsMap = new HashMap();
        this.usersMap = new HashMap();
        this.placesMap = new HashMap();
        this.tweetsMap = new HashMap();
        this.parse(json, isJSONStoreEnabled);
    }

    public /* synthetic */ UsersResponse(JSONObject jSONObject, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(jSONObject, bl);
    }

    private final void parse(JSONObject jsonObject, boolean isJSONStoreEnabled) {
        List<User2> list = this.users;
        Intrinsics.checkNotNull(list, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<twitter4j.User2>");
        List users = TypeIntrinsics.asMutableList(list);
        users.clear();
        JSONObject includes = jsonObject.optJSONObject("includes");
        V2Util.INSTANCE.collectPolls(includes, this.pollsMap);
        V2Util.INSTANCE.collectUsers(includes, this.usersMap);
        V2Util.INSTANCE.collectPlaces(includes, this.placesMap);
        V2Util.INSTANCE.collectTweets(includes, this.tweetsMap);
        Object data = jsonObject.get("data");
        if (data instanceof JSONArray) {
            int n = ((JSONArray)data).length();
            for (int i = 0; i < n; ++i) {
                JSONObject e = ((JSONArray)data).getJSONObject(i);
                Intrinsics.checkNotNullExpressionValue((Object)e, (String)"e");
                users.add(User2.Companion.parse(e));
            }
        } else if (data instanceof JSONObject) {
            users.add(User2.Companion.parse((JSONObject)data));
        }
        this.meta = V2Util.INSTANCE.parseMeta(jsonObject);
        if (isJSONStoreEnabled) {
            TwitterObjectFactory.registerJSONObject((Object)this, (Object)jsonObject);
        }
    }

    @Nullable
    public RateLimitStatus getRateLimitStatus() {
        return this.rateLimitStatus;
    }

    public int getAccessLevel() {
        return this.accessLevel;
    }

    @NotNull
    public String toString() {
        return "UsersResponse(rateLimitStatus=" + this.rateLimitStatus + ", accessLevel=" + this.accessLevel + ", users=" + this.users + ", pollsMap=" + this.pollsMap + ", usersMap=" + this.usersMap + ", tweetsMap=" + this.tweetsMap + ", meta=" + this.meta + ')';
    }
}

