/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import twitter4j.ErrorInfo;
import twitter4j.HttpParameter;
import twitter4j.JSONArray;
import twitter4j.JSONObject;
import twitter4j.JSONObjectExKt;
import twitter4j.Media;
import twitter4j.MediaKey;
import twitter4j.Meta;
import twitter4j.PaginationToken;
import twitter4j.ParseUtil;
import twitter4j.Place2;
import twitter4j.Poll;
import twitter4j.Tweet;
import twitter4j.User2;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ+\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ&\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\tJ&\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u001c\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J$\u0010\u0017\u001a\u00020\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u00132\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001aJ$\u0010\u001d\u001a\u00020\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u00132\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001f0\u001aJ$\u0010 \u001a\u00020\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u00132\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\"0\u001aJ$\u0010#\u001a\u00020\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u00132\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020%0\u001aJ$\u0010&\u001a\u00020\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u00132\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020(0\u001aJ\u0012\u0010)\u001a\u0004\u0018\u00010\t2\b\u0010*\u001a\u0004\u0018\u00010+J\u001a\u0010,\u001a\u0004\u0018\u00010+2\u0006\u0010-\u001a\u00020\t2\b\u0010.\u001a\u0004\u0018\u00010\u0013J \u0010/\u001a\u00020\u00042\b\u00100\u001a\u0004\u0018\u0001012\u000e\u00102\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u0015J\u0010\u00103\u001a\u0004\u0018\u0001042\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u00065"}, d2={"Ltwitter4j/V2Util;", "", "()V", "addHttpParamIfNotNull", "", "params", "Ljava/util/ArrayList;", "Ltwitter4j/HttpParameter;", "name", "", "value", "", "(Ljava/util/ArrayList;Ljava/lang/String;Ljava/lang/Integer;)V", "", "(Ljava/util/ArrayList;Ljava/lang/String;Ljava/lang/Long;)V", "token", "Ltwitter4j/PaginationToken;", "collectErrors", "jsonObject", "Ltwitter4j/JSONObject;", "errors", "", "Ltwitter4j/ErrorInfo;", "collectMediaKeys", "includes", "mediaMap", "Ljava/util/HashMap;", "Ltwitter4j/MediaKey;", "Ltwitter4j/Media;", "collectPlaces", "placesMap", "Ltwitter4j/Place2;", "collectPolls", "pollsMap", "Ltwitter4j/Poll;", "collectTweets", "tweetsMap", "Ltwitter4j/Tweet;", "collectUsers", "usersMap", "Ltwitter4j/User2;", "dateToISO8601", "date", "Ljava/util/Date;", "parseISO8601Date", "key", "data", "parseIds", "array", "Ltwitter4j/JSONArray;", "listToStore", "parseMeta", "Ltwitter4j/Meta;", "twitter4j-v2-support"})
public final class V2Util {
    @NotNull
    public static final V2Util INSTANCE = new V2Util();

    private V2Util() {
    }

    public final void collectPolls(@Nullable JSONObject includes, @NotNull HashMap<Long, Poll> pollsMap) {
        block1: {
            Intrinsics.checkNotNullParameter(pollsMap, (String)"pollsMap");
            JSONObject jSONObject = includes;
            if (jSONObject == null || (jSONObject = jSONObject.optJSONArray("polls")) == null) break block1;
            JSONObject polls = jSONObject;
            boolean bl = false;
            int n = polls.length();
            for (int i = 0; i < n; ++i) {
                Poll poll;
                String pollString = polls.getString(i);
                Poll it = poll = new Poll(new JSONObject(pollString));
                boolean bl2 = false;
                it.setJsonText(pollString);
                Poll poll2 = poll;
                ((Map)pollsMap).put(poll2.getId(), poll2);
            }
        }
    }

    public final void collectMediaKeys(@Nullable JSONObject includes, @NotNull HashMap<MediaKey, Media> mediaMap) {
        block1: {
            Intrinsics.checkNotNullParameter(mediaMap, (String)"mediaMap");
            JSONObject jSONObject = includes;
            if (jSONObject == null || (jSONObject = jSONObject.optJSONArray("media")) == null) break block1;
            JSONObject mediaArray = jSONObject;
            boolean bl = false;
            int n = mediaArray.length();
            for (int i = 0; i < n; ++i) {
                Media media;
                String mediaString = mediaArray.getString(i);
                Media it = media = Media.Companion.parse(new JSONObject(mediaString));
                boolean bl2 = false;
                Media media2 = media;
                ((Map)mediaMap).put(media2.getMediaKey(), media2);
            }
        }
    }

    public final void collectUsers(@Nullable JSONObject includes, @NotNull HashMap<Long, User2> usersMap) {
        block1: {
            Intrinsics.checkNotNullParameter(usersMap, (String)"usersMap");
            JSONObject jSONObject = includes;
            if (jSONObject == null || (jSONObject = jSONObject.optJSONArray("users")) == null) break block1;
            JSONObject users = jSONObject;
            boolean bl = false;
            int n = users.length();
            for (int i = 0; i < n; ++i) {
                JSONObject jSONObject2 = users.getJSONObject(i);
                Intrinsics.checkNotNullExpressionValue((Object)jSONObject2, (String)"users.getJSONObject(i)");
                User2 user = User2.Companion.parse(jSONObject2);
                ((Map)usersMap).put(user.getId(), user);
            }
        }
    }

    public final void collectPlaces(@Nullable JSONObject includes, @NotNull HashMap<String, Place2> placesMap) {
        block1: {
            Intrinsics.checkNotNullParameter(placesMap, (String)"placesMap");
            JSONObject jSONObject = includes;
            if (jSONObject == null || (jSONObject = jSONObject.optJSONArray("places")) == null) break block1;
            JSONObject places = jSONObject;
            boolean bl = false;
            int n = places.length();
            for (int i = 0; i < n; ++i) {
                JSONObject jSONObject2 = places.getJSONObject(i);
                Intrinsics.checkNotNullExpressionValue((Object)jSONObject2, (String)"places.getJSONObject(i)");
                Place2 place = Place2.Companion.parse(jSONObject2);
                ((Map)placesMap).put(place.getId(), place);
            }
        }
    }

    public final void collectTweets(@Nullable JSONObject includes, @NotNull HashMap<Long, Tweet> tweetsMap) {
        block1: {
            Intrinsics.checkNotNullParameter(tweetsMap, (String)"tweetsMap");
            JSONObject jSONObject = includes;
            if (jSONObject == null || (jSONObject = jSONObject.optJSONArray("tweets")) == null) break block1;
            JSONObject tweets = jSONObject;
            boolean bl = false;
            int n = tweets.length();
            for (int i = 0; i < n; ++i) {
                JSONObject jSONObject2 = tweets.getJSONObject(i);
                Intrinsics.checkNotNullExpressionValue((Object)jSONObject2, (String)"tweets.getJSONObject(i)");
                Tweet tweet = Tweet.Companion.parse(jSONObject2);
                ((Map)tweetsMap).put(tweet.getId(), tweet);
            }
        }
    }

    public final void collectErrors(@NotNull JSONObject jsonObject, @NotNull List<ErrorInfo> errors) {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        Intrinsics.checkNotNullParameter(errors, (String)"errors");
        JSONArray errorsArray = jsonObject.optJSONArray("errors");
        if (errorsArray != null) {
            List errors1 = TypeIntrinsics.asMutableList(errors);
            int n = errorsArray.length();
            for (int i = 0; i < n; ++i) {
                JSONObject jSONObject = errorsArray.getJSONObject(i);
                Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"errorsArray.getJSONObject(i)");
                errors1.add(new ErrorInfo(jSONObject));
            }
        }
    }

    public final void parseIds(@Nullable JSONArray array, @Nullable List<Long> listToStore) {
        if (array != null) {
            Intrinsics.checkNotNull(listToStore, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.Long>");
            List list = TypeIntrinsics.asMutableList(listToStore);
            int n = array.length();
            for (int v = 0; v < n; ++v) {
                list.add(array.getLong(v));
            }
        }
    }

    @Nullable
    public final Meta parseMeta(@NotNull JSONObject jsonObject) {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        if (jsonObject.has("meta")) {
            PaginationToken paginationToken;
            PaginationToken paginationToken2;
            PaginationToken paginationToken3;
            String it;
            int n;
            JSONObject metaObject = jsonObject.optJSONObject("meta");
            int n2 = metaObject.getInt("result_count");
            String string = metaObject.optString("previous_token", null);
            if (string != null) {
                String string2 = string;
                n = n2;
                boolean bl = false;
                paginationToken3 = new PaginationToken(it);
                n2 = n;
                paginationToken2 = paginationToken3;
            } else {
                paginationToken2 = null;
            }
            String string3 = metaObject.optString("next_token", null);
            if (string3 != null) {
                it = string3;
                paginationToken3 = paginationToken2;
                n = n2;
                boolean bl = false;
                PaginationToken paginationToken4 = new PaginationToken(it);
                n2 = n;
                paginationToken2 = paginationToken3;
                paginationToken = paginationToken4;
            } else {
                paginationToken = null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)metaObject, (String)"metaObject");
            Long l = JSONObjectExKt.optLongOrNull(metaObject, "newest_id");
            Long l2 = JSONObjectExKt.optLongOrNull(metaObject, "oldest_id");
            PaginationToken paginationToken5 = paginationToken;
            PaginationToken paginationToken6 = paginationToken2;
            int n3 = n2;
            return new Meta(n3, paginationToken6, paginationToken5, l2, l);
        }
        return null;
    }

    @Nullable
    public final String dateToISO8601(@Nullable Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        return sdf.format(date);
    }

    @Nullable
    public final Date parseISO8601Date(@NotNull String key, @Nullable JSONObject data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return ParseUtil.getDate((String)key, (JSONObject)data, (String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    }

    public final void addHttpParamIfNotNull(@NotNull ArrayList<HttpParameter> params, @NotNull String name, @Nullable String value) {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (value != null) {
            params.add(new HttpParameter(name, value));
        }
    }

    public final void addHttpParamIfNotNull(@NotNull ArrayList<HttpParameter> params, @NotNull String name, @Nullable PaginationToken token) {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (token != null) {
            params.add(new HttpParameter(name, token.getValue()));
        }
    }

    public final void addHttpParamIfNotNull(@NotNull ArrayList<HttpParameter> params, @NotNull String name, @Nullable Integer value) {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (value != null) {
            params.add(new HttpParameter(name, value.intValue()));
        }
    }

    public final void addHttpParamIfNotNull(@NotNull ArrayList<HttpParameter> params, @NotNull String name, @Nullable Long value) {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (value != null) {
            params.add(new HttpParameter(name, value.longValue()));
        }
    }
}

