/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.conf;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import twitter4j.conf.Configuration;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u000e\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0018\u0010\u000e\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0004H\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\b\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u0014"}, d2={"Ltwitter4j/conf/V2CustomConfiguration;", "", "()V", "clientId", "", "getClientId", "()Ljava/lang/String;", "clientId$delegate", "Lkotlin/Lazy;", "props", "Ljava/util/Properties;", "redirectUri", "getRedirectUri", "redirectUri$delegate", "loadProperties", "", "", "inputStream", "Ljava/io/InputStream;", "path", "twitter4j-v2-support"})
public final class V2CustomConfiguration {
    private Properties props;
    @NotNull
    private final Lazy clientId$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
        final /* synthetic */ V2CustomConfiguration this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        public final String invoke() {
            Properties properties = V2CustomConfiguration.access$getProps$p(this.this$0);
            if (properties == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"props");
                properties = null;
            }
            return properties.getProperty("oauth2.client_id", "");
        }
    }));
    @NotNull
    private final Lazy redirectUri$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
        final /* synthetic */ V2CustomConfiguration this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        public final String invoke() {
            Properties properties = V2CustomConfiguration.access$getProps$p(this.this$0);
            if (properties == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"props");
                properties = null;
            }
            return properties.getProperty("oauth2.redirect_uri", "");
        }
    }));

    public V2CustomConfiguration() {
        this.loadProperties();
    }

    @NotNull
    public final String getClientId() {
        Lazy lazy = this.clientId$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-clientId>(...)");
        return (String)object;
    }

    @NotNull
    public final String getRedirectUri() {
        Lazy lazy = this.redirectUri$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-redirectUri>(...)");
        return (String)object;
    }

    private final void loadProperties() {
        try {
            Object object = System.getProperties().clone();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.Properties");
            this.props = (Properties)object;
            try {
                Map<String, String> envMap = System.getenv();
                for (String key : envMap.keySet()) {
                    Properties properties = this.props;
                    if (properties == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"props");
                        properties = null;
                    }
                    properties.setProperty(key, envMap.get(key));
                }
            }
            catch (SecurityException envMap) {
            }
        }
        catch (SecurityException ignore) {
            this.props = new Properties();
        }
        String TWITTER4J_PROPERTIES = "twitter4j.properties";
        Properties properties = this.props;
        if (properties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"props");
            properties = null;
        }
        this.loadProperties(properties, "" + '.' + File.separatorChar + TWITTER4J_PROPERTIES);
        Properties properties2 = this.props;
        if (properties2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"props");
            properties2 = null;
        }
        this.loadProperties(properties2, Configuration.class.getResourceAsStream('/' + TWITTER4J_PROPERTIES));
        Properties properties3 = this.props;
        if (properties3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"props");
            properties3 = null;
        }
        this.loadProperties(properties3, Configuration.class.getResourceAsStream("/WEB-INF/" + TWITTER4J_PROPERTIES));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean loadProperties(Properties props, String path) {
        block7: {
            try {
                File file = new File(path);
                if (!file.exists() || !file.isFile()) break block7;
                Closeable closeable = new FileInputStream(file);
                Throwable throwable = null;
                try {
                    FileInputStream it = (FileInputStream)closeable;
                    boolean bl = false;
                    props.load(it);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private final boolean loadProperties(Properties props, InputStream inputStream) {
        try {
            props.load(inputStream);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final /* synthetic */ Properties access$getProps$p(V2CustomConfiguration $this) {
        return $this.props;
    }
}

