/*
 * Decompiled with CFR 0.152.
 */
package com.quasiris.qsc.reader;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.quasiris.qsc.reader.FeedingQueue;
import de.tblsoft.solr.pipeline.AbstractReader;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.filter.SimpleMapping;
import de.tblsoft.solr.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedingQueueReader
extends AbstractReader {
    private static Logger LOG = LoggerFactory.getLogger(FeedingQueueReader.class);
    private Map<String, List<String>> mapping;

    @Override
    public void read() {
        SimpleMapping simpleMapping = new SimpleMapping(this.getPropertyAsList("mapping", new ArrayList<String>()), this.getPropertyAsList("config", new ArrayList<String>()));
        this.mapping = simpleMapping.getMapping();
        String url = this.getProperty("url", null);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            FeedingQueue[] feedingQueueList;
            InputStream inputStream = IOUtils.getInputStream(url);
            for (FeedingQueue feedingQueue : feedingQueueList = (FeedingQueue[])objectMapper.readValue(inputStream, FeedingQueue[].class)) {
                try {
                    Document document;
                    if ("delete".equals(feedingQueue.getOperation())) {
                        document = new Document();
                        document.setField("id", feedingQueue.getDocumentId());
                        document.setField("operation", "delete");
                        this.executer.document(document);
                        continue;
                    }
                    document = this.parseJsonDocument(feedingQueue.getPayload());
                    document.setField("id", feedingQueue.getDocumentId());
                    document.setField("batchId", feedingQueue.getBatchId());
                    document.setField("processId", this.executer.getProcessId());
                    this.executer.document(document);
                }
                catch (Exception e) {
                    LOG.error("could not map document with id " + feedingQueue.getId() + " with operation: " + feedingQueue.getOperation() + " payload: " + feedingQueue.getPayload());
                    throw e;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Document parseJsonDocument(String json) {
        DocumentContext documentContext = JsonPath.parse((String)json);
        Document document = new Document();
        for (Map.Entry<String, List<String>> mappingEntry : this.mapping.entrySet()) {
            try {
                Object parsedValue = documentContext.read(mappingEntry.getKey(), new Predicate[0]);
                for (String target : mappingEntry.getValue()) {
                    document.setField(target, parsedValue);
                }
            }
            catch (PathNotFoundException pathNotFoundException) {
            }
        }
        return document;
    }
}

