/*
 * Decompiled with CFR 0.152.
 */
package com.quasiris.qsc.writer;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.quasiris.qsc.writer.dto.Header;
import com.quasiris.qsc.writer.dto.QscFeedingDocument;
import de.tblsoft.solr.http.HTTPHelper;
import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.util.DocumentMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QscDataPushWriter
extends AbstractFilter {
    private static Logger LOG = LoggerFactory.getLogger(QscDataPushWriter.class);
    private ObjectMapper objectMapper = new ObjectMapper();
    private int batchSize = 100;
    private String idField = "id";
    private String url;
    private List<String> header;
    private List<QscFeedingDocument> batch = new ArrayList<QscFeedingDocument>();

    @Override
    public void init() {
        this.url = this.getProperty("url", null);
        this.header = this.getPropertyAsList("header", new ArrayList<String>());
        this.batchSize = this.getPropertyAsInt("batchSize", 100);
        this.idField = this.getProperty("idField", "id");
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        String fullFeedStartUrl = this.url.replace("bulk/qsc", "fullfeed/start");
        HTTPHelper.post(fullFeedStartUrl, "{}", this.header);
        LOG.info("Full feed start: {}", (Object)fullFeedStartUrl);
        super.init();
    }

    @Override
    public void document(Document document) {
        QscFeedingDocument qscFeedingDocument = this.map(document);
        this.batch.add(qscFeedingDocument);
        if (this.batch.size() > this.batchSize) {
            this.sendBatch(this.batch);
            this.batch = new ArrayList<QscFeedingDocument>();
        }
    }

    public QscFeedingDocument map(Document document) {
        QscFeedingDocument feedingDocument = new QscFeedingDocument();
        Map<String, Object> outputDocument = DocumentMapper.toMap(document);
        feedingDocument.setPayload(outputDocument);
        Header header = new Header();
        header.setAction("update");
        String id = document.getFieldValue(this.idField);
        if (id == null) {
            id = UUID.randomUUID().toString();
        }
        header.setId(id);
        feedingDocument.setHeader(header);
        return feedingDocument;
    }

    public void sendBatch(List<QscFeedingDocument> data) {
        try {
            String dataAsString = this.objectMapper.writeValueAsString(data);
            HTTPHelper.post(this.url, dataAsString, this.header);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void end() {
        this.sendBatch(this.batch);
        this.batch = new ArrayList<QscFeedingDocument>();
        String fullFeedEndUrl = this.url.replace("bulk/qsc", "fullfeed/end");
        HTTPHelper.post(fullFeedEndUrl, "{}", this.header);
        LOG.info("Full feed end: {}", (Object)fullFeedEndUrl);
        super.end();
    }
}

