/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.cache;

import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.util.DocumentUtils;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.time.Duration;
import java.time.Instant;
import java.util.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCache {
    private static Logger LOG = LoggerFactory.getLogger(FileCache.class);
    private String cacheBasePath;
    private String fileExtension;
    private Duration maxAge;

    public FileCache(String cacheBasePath, String fileExtension, Duration maxAge) {
        this.cacheBasePath = cacheBasePath;
        this.fileExtension = fileExtension;
        this.maxAge = maxAge;
    }

    public Document readFromCache(String url) {
        if (this.cacheBasePath == null) {
            return null;
        }
        try {
            Instant lastModified;
            Duration fileAge;
            File target = this.getTargetFile(url);
            if (!Files.exists(target.toPath(), new LinkOption[0])) {
                return null;
            }
            if (this.maxAge != null && this.maxAge.compareTo(fileAge = Duration.between(lastModified = Files.getLastModifiedTime(target.toPath(), new LinkOption[0]).toInstant(), Instant.now())) < 0) {
                return null;
            }
            return DocumentUtils.readFromFile(target);
        }
        catch (Exception e) {
            LOG.error("error " + e.getMessage() + " reading from cache for url: " + url, (Throwable)e);
            return null;
        }
    }

    public void writeToCache(String url, Document document) throws Exception {
        if (this.cacheBasePath == null) {
            return;
        }
        File target = this.getTargetFile(url);
        DocumentUtils.writeToFile(target, document);
    }

    private File getTargetFile(String url) throws URISyntaxException {
        String hashedUrl = this.hash(url);
        URI uri = new URI(url);
        File target = new File(this.cacheBasePath + "/" + uri.getHost() + "/" + hashedUrl + this.fileExtension);
        return target;
    }

    private String hash(String url) {
        String base64 = Base64.getEncoder().encodeToString(url.getBytes());
        if (base64.length() < 255) {
            return base64;
        }
        return DigestUtils.md5Hex((byte[])url.getBytes());
    }
}

