/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.compare;

import de.tblsoft.solr.compare.Result;
import de.tblsoft.solr.compare.SearchResult;

public class SearchResultDiff {
    private SearchResult reference;
    private SearchResult test;
    private int resultsPerPage = 72;
    private int positionChangedCount = 0;
    private double numFoundRelative = 0.0;
    private long numFoundTotal = 0L;
    private int positions;
    private int responseTimeTotal = 0;
    private double responseTimeRelative = 0.0;

    public SearchResultDiff(SearchResult reference, SearchResult test) {
        this.reference = reference;
        this.test = test;
    }

    public void compute() {
        this.computeNumFoundRelative();
        this.computeNumFoundTotal();
        this.computeResponseTimeRelative();
        this.computeResponseTimeTotal();
        this.computePositions();
    }

    private void computeResponseTimeRelative() {
        if ((double)this.reference.getResponseTime() == 0.0 && (double)this.test.getResponseTime() == 0.0) {
            this.responseTimeRelative = 0.0;
            return;
        }
        this.responseTimeRelative = Math.abs(100 * this.test.getResponseTime() / this.reference.getResponseTime() - 100);
    }

    private void computeResponseTimeTotal() {
        this.responseTimeTotal = Math.abs(this.reference.getResponseTime() - this.test.getResponseTime());
    }

    private void computeNumFoundRelative() {
        if ((double)this.reference.getNumFound() == 0.0 && (double)this.test.getNumFound() == 0.0) {
            this.numFoundRelative = 0.0;
            return;
        }
        if ((double)this.reference.getNumFound() == 0.0) {
            this.numFoundRelative = 100.0;
            return;
        }
        this.numFoundRelative = Math.abs(100L * this.test.getNumFound() / this.reference.getNumFound() - 100L);
    }

    private void computeNumFoundTotal() {
        this.numFoundTotal = Math.abs(this.reference.getNumFound() - this.test.getNumFound());
    }

    private void computePositions() {
        int positionDiff = 0;
        for (Result result : this.reference.getResultList()) {
            Result testResult = this.getTestResultById(result.getId());
            if (testResult == null) {
                positionDiff += this.resultsPerPage - result.getPosition();
                continue;
            }
            int diff = Math.abs(result.getPosition() - testResult.getPosition());
            positionDiff += diff;
            if (diff == 0) continue;
            ++this.positionChangedCount;
        }
        this.positions = positionDiff;
    }

    Result getTestResultById(String id) {
        for (Result result : this.test.getResultList()) {
            if (!result.getId().equals(id)) continue;
            return result;
        }
        return null;
    }

    public double getNumFoundRelative() {
        return this.numFoundRelative;
    }

    public long getNumFoundTotal() {
        return this.numFoundTotal;
    }

    public int getPositions() {
        return this.positions;
    }

    public int getPositionChangedCount() {
        return this.positionChangedCount;
    }

    public int getResponseTimeTotal() {
        return this.responseTimeTotal;
    }

    public double getResponseTimeRelative() {
        return this.responseTimeRelative;
    }

    public double getTotalDiff() {
        return 0.0;
    }
}

