/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.compare;

import de.tblsoft.solr.compare.Result;
import de.tblsoft.solr.compare.SearchResult;
import de.tblsoft.solr.compare.SearchResultDiff;
import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.SolrUrl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.params.SolrParams;

public class SolrCompareFilter
extends AbstractFilter {
    private SolrUrl solrReferenceUrl;
    private SolrUrl solrTestUrl;
    private SolrClient solrReferenceClient;
    private SolrClient solrTestClient;
    private boolean failOnError = true;
    private String idField;

    @Override
    public void init() {
        super.init();
        this.solrReferenceUrl = new SolrUrl(this.filter.getProperty(), "solrReferenceUrl");
        this.solrTestUrl = new SolrUrl(this.filter.getProperty(), "solrTestUrl");
        this.solrReferenceClient = new HttpSolrClient(this.solrReferenceUrl.getSolrClientBaseUrl());
        this.solrTestClient = new HttpSolrClient(this.solrTestUrl.getSolrClientBaseUrl());
        this.idField = this.getProperty("idField", "id");
    }

    @Override
    public void document(Document document) {
        SearchResult reference = this.query(document, this.solrReferenceUrl, this.solrReferenceClient);
        SearchResult test = this.query(document, this.solrTestUrl, this.solrTestClient);
        SearchResultDiff searchResultDiff = new SearchResultDiff(reference, test);
        document.setField("numFoundRelativeDiff", searchResultDiff.getNumFoundRelative());
        document.setField("numFoundTotalDiff", searchResultDiff.getNumFoundTotal());
        document.setField("positionChangedCount", searchResultDiff.getPositionChangedCount());
        document.setField("positionsDiff", searchResultDiff.getPositions());
        document.setField("responseTimeRelativeDiff", searchResultDiff.getResponseTimeRelative());
        document.setField("responseTimeTotalDiff", searchResultDiff.getResponseTimeTotal());
        document.setField("totalDiff", searchResultDiff.getTotalDiff());
        super.document(document);
    }

    SearchResult query(Document document, SolrUrl solrUrl, SolrClient solrClient) {
        SolrQuery solrQuery = new SolrQuery();
        HashMap<String, String> valueMap = new HashMap<String, String>();
        String queryString = document.getFieldValue("query");
        valueMap.put("query", queryString);
        StrSubstitutor strSubstitutor = new StrSubstitutor(valueMap);
        for (Map<String, String> map : solrUrl.getQuery()) {
            for (String key : map.keySet()) {
                String value = map.get(key);
                value = strSubstitutor.replace(value);
                solrQuery.add(key, new String[]{value});
            }
        }
        SearchResult searchResult = new SearchResult();
        try {
            QueryResponse response = solrClient.query((SolrParams)solrQuery);
            searchResult.setResponseTime(response.getQTime());
            searchResult.setNumFound(response.getResults().getNumFound());
            searchResult.setQuery(queryString);
            Iterator resultIterator = response.getResults().iterator();
            int position = 0;
            while (resultIterator.hasNext()) {
                SolrDocument solrDocument = (SolrDocument)resultIterator.next();
                String id = (String)solrDocument.getFieldValue("id");
                Result result = new Result(id, position++);
                searchResult.getResultList().add(result);
            }
        }
        catch (Exception e) {
            if (this.failOnError) {
                throw new RuntimeException(e);
            }
            searchResult.setValid(false);
            searchResult.setErrorMessage(e.getMessage());
        }
        return searchResult;
    }
}

