/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.crawl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.tblsoft.solr.crawl.Breadcrumb;
import de.tblsoft.solr.crawl.Custom;
import de.tblsoft.solr.crawl.Meta;
import de.tblsoft.solr.crawl.attr.Attributes;
import de.tblsoft.solr.http.UrlUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Webpage {
    private String url;
    private String domain;
    private long parseTime;
    private String rawHtml;
    private String title;
    private String metaDescription;
    private String canonical;
    private String image;
    private String baseUrl;
    private List<String> h1;
    private List<String> h2;
    private List<String> h3;
    private List<String> h4;
    private List<String> h5;
    private List<String> h6;
    private Collection<String> links;
    private Collection<String> domains;
    private Collection<String> images;
    private Collection<JsonNode> jsonLd;
    private Meta meta;
    private Map<String, Custom> custom;
    private Attributes attributes;
    private Breadcrumb breadcrumb;

    public String getRawHtml() {
        return this.rawHtml;
    }

    public void setRawHtml(String rawHtml) {
        this.rawHtml = rawHtml;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getMetaDescription() {
        return this.metaDescription;
    }

    public void setMetaDescription(String metaDescription) {
        this.metaDescription = metaDescription;
    }

    public String getCanonical() {
        return this.canonical;
    }

    public void setCanonical(String canonical) {
        this.canonical = canonical;
    }

    public List<String> getH1() {
        return this.h1;
    }

    public void setH1(List<String> h1) {
        this.h1 = h1;
    }

    public List<String> getH2() {
        return this.h2;
    }

    public void setH2(List<String> h2) {
        this.h2 = h2;
    }

    public List<String> getH3() {
        return this.h3;
    }

    public void setH3(List<String> h3) {
        this.h3 = h3;
    }

    public List<String> getH4() {
        return this.h4;
    }

    public void setH4(List<String> h4) {
        this.h4 = h4;
    }

    public List<String> getH5() {
        return this.h5;
    }

    public void setH5(List<String> h5) {
        this.h5 = h5;
    }

    public List<String> getH6() {
        return this.h6;
    }

    public void setH6(List<String> h6) {
        this.h6 = h6;
    }

    public Collection<String> getLinks() {
        return this.links;
    }

    public void setLinks(Collection<String> links) {
        this.links = links;
    }

    public Collection<String> getImages() {
        return this.images;
    }

    public void setImages(Collection<String> images) {
        this.images = images;
    }

    public Collection<JsonNode> getJsonLd() {
        return this.jsonLd;
    }

    public void setJsonLd(Collection<String> jsonLd) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayList<JsonNode> tempList = new ArrayList<JsonNode>();
        for (String json : jsonLd) {
            try {
                JsonNode actualObj = mapper.readTree(json);
                tempList.add(actualObj);
            }
            catch (IOException iOException) {}
        }
        this.jsonLd = tempList;
    }

    public Meta getMeta() {
        if (this.meta == null) {
            this.meta = new Meta();
        }
        return this.meta;
    }

    public void setMeta(Meta meta) {
        this.meta = meta;
    }

    public Map<String, Custom> getCustom() {
        return this.custom;
    }

    public void setCustom(Map<String, Custom> custom) {
        this.custom = custom;
    }

    public long getParseTime() {
        return this.parseTime;
    }

    public void setParseTime(long parseTime) {
        this.parseTime = parseTime;
    }

    public Collection<String> getDomains() {
        return this.domains;
    }

    public void setDomains(Collection<String> domains) {
        this.domains = domains;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public boolean hasAttributes() {
        return this.attributes != null;
    }

    public Breadcrumb getBreadcrumb() {
        return this.breadcrumb;
    }

    public void setBreadcrumb(Breadcrumb breadcrumb) {
        this.breadcrumb = breadcrumb;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDomain() {
        if (this.domain == null && this.url != null) {
            this.domain = UrlUtil.getHost(this.url);
        }
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }
}

