/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.crawl.attr;

import de.tblsoft.solr.crawl.JSoupAnalyzer;
import de.tblsoft.solr.crawl.attr.Attribute;
import de.tblsoft.solr.crawl.attr.AttributeExtractor;
import de.tblsoft.solr.crawl.attr.Attributes;
import java.util.ArrayList;
import java.util.List;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class TableTdTdAttributeExtractor
implements AttributeExtractor {
    private JSoupAnalyzer jSoupAnalyzer;

    public TableTdTdAttributeExtractor(JSoupAnalyzer jSoupAnalyzer) {
        this.jSoupAnalyzer = jSoupAnalyzer;
    }

    @Override
    public List<Attribute> extractAttributes(Attributes attributes) {
        ArrayList<Attribute> attributeNames = new ArrayList<Attribute>();
        if (attributes == null || attributes.getSelector() == null) {
            return null;
        }
        for (String selector : attributes.getSelector()) {
            for (Element element : this.jSoupAnalyzer.getJsoupDocument().select(selector).select("tr")) {
                Elements td = element.select("td");
                if (td.size() != 2) continue;
                String name = ((Element)element.select("td").get(0)).text();
                String value = ((Element)element.select("td").get(1)).text();
                Attribute attribute = new Attribute();
                attribute.setName(name);
                attribute.setValue(value);
                attributeNames.add(attribute);
            }
        }
        return attributeNames;
    }
}

