/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.elastic;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import de.tblsoft.solr.http.ElasticHelper;
import de.tblsoft.solr.http.HTTPHelper;
import de.tblsoft.solr.http.UrlUtil;
import de.tblsoft.solr.pipeline.bean.Document;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ElasticScrollQuery {
    private String url;
    private String request;
    private String scroll = "1m";
    private String scrollId = null;
    boolean hasHits = false;
    private String pagedUrl = null;
    private String scrollBaseUrl;
    private String searchBaseUrl;
    private Gson gson;
    private boolean usePostMethod = false;

    public ElasticScrollQuery(String url) throws URISyntaxException {
        this.url = url;
        this.pagedUrl = UrlUtil.appendParameter(url, "scroll=" + this.scroll);
        this.scrollBaseUrl = ElasticHelper.getScrollUrl(this.url);
        this.searchBaseUrl = ElasticHelper.getSearchUrl(this.url);
        GsonBuilder builder = new GsonBuilder();
        this.gson = builder.create();
    }

    public void setRequest(String request) {
        this.request = request;
        this.usePostMethod = true;
        this.pagedUrl = this.searchBaseUrl + "?scroll=" + this.scroll;
    }

    public void setScroll(String scroll) {
        this.scroll = scroll;
    }

    public List<Document> getAllDocuments() throws Exception {
        List<Document> docs;
        ArrayList<Document> allDocs = new ArrayList<Document>();
        while ((docs = this.nextDocuments()) != null) {
            allDocs.addAll(docs);
        }
        return allDocs;
    }

    public List<Document> nextDocuments() throws Exception {
        ArrayList<Document> documents = new ArrayList<Document>();
        String response = this.usePostMethod ? HTTPHelper.post(this.pagedUrl, this.request, "application/json") : HTTPHelper.get(this.pagedUrl);
        JsonElement jsonResponse = (JsonElement)this.gson.fromJson(response, JsonElement.class);
        if (jsonResponse.getAsJsonObject().get("_scroll_id") != null) {
            this.scrollId = jsonResponse.getAsJsonObject().get("_scroll_id").getAsString();
        }
        Iterator hitsIterator = jsonResponse.getAsJsonObject().get("hits").getAsJsonObject().get("hits").getAsJsonArray().iterator();
        this.hasHits = false;
        while (hitsIterator.hasNext()) {
            this.hasHits = true;
            Document document = new Document();
            for (Map.Entry entry : ((JsonElement)hitsIterator.next()).getAsJsonObject().get("_source").getAsJsonObject().entrySet()) {
                if (((JsonElement)entry.getValue()).isJsonArray()) {
                    Iterator iter = ((JsonElement)entry.getValue()).getAsJsonArray().iterator();
                    ArrayList<String> values = new ArrayList<String>();
                    while (iter.hasNext()) {
                        JsonElement nextElement = (JsonElement)iter.next();
                        if (nextElement.isJsonPrimitive()) {
                            values.add(nextElement.getAsString());
                            continue;
                        }
                        values.add(nextElement.getAsJsonObject().toString());
                    }
                    document.addField((String)entry.getKey(), values);
                    continue;
                }
                if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                document.addField((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
            documents.add(document);
        }
        if (this.usePostMethod) {
            this.pagedUrl = this.scrollBaseUrl;
            this.request = "{ \"scroll\" : \"" + this.scroll + "\", \"scroll_id\" : \"" + this.scrollId + "\"}";
        } else {
            this.pagedUrl = this.scrollBaseUrl + "?scroll=" + this.scroll + "&scroll_id=" + this.scrollId;
        }
        if (this.hasHits) {
            return documents;
        }
        return null;
    }
}

