/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.http;

import com.google.common.base.Strings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPHelper {
    private static Logger LOG = LoggerFactory.getLogger(HTTPHelper.class);

    public static String delete(String url) {
        try {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpDelete httpPost = new HttpDelete(url);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            StringBuilder responseBuilder = new StringBuilder();
            responseBuilder.append(EntityUtils.toString((HttpEntity)response.getEntity()));
            httpclient.close();
            return responseBuilder.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String put(String url, String postString, String contentType) {
        try {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpPut httpPost = new HttpPut(url);
            if (postString != null) {
                StringEntity entity = new StringEntity(postString, "UTF-8");
                httpPost.setEntity((HttpEntity)entity);
            }
            if (!Strings.isNullOrEmpty((String)contentType)) {
                httpPost.setHeader("Content-Type", contentType);
            }
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            StringBuilder responseBuilder = new StringBuilder();
            responseBuilder.append(EntityUtils.toString((HttpEntity)response.getEntity()));
            if (response.getStatusLine().getStatusCode() != 200) {
                LOG.info(responseBuilder.toString());
            }
            httpclient.close();
            return responseBuilder.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String post(String url, String postString) {
        return HTTPHelper.post(url, postString, new ArrayList<String>());
    }

    public static String post(String url, String postString, String contentType) {
        return HTTPHelper.post(url, postString, Arrays.asList("Content-Type: " + contentType));
    }

    public static String post(String url, String postString, List<String> headers) {
        try {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(url);
            StringEntity entity = new StringEntity(postString, "UTF-8");
            httpPost.setEntity((HttpEntity)entity);
            for (String header : headers) {
                String[] splitted = header.split(":");
                if (splitted.length != 2) {
                    throw new RuntimeException("Invalid header definition");
                }
                httpPost.setHeader(splitted[0].trim(), splitted[1].trim());
            }
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            StringBuilder responseBuilder = new StringBuilder();
            responseBuilder.append(EntityUtils.toString((HttpEntity)response.getEntity()));
            httpclient.close();
            if (response.getStatusLine().getStatusCode() >= 300) {
                throw new RuntimeException("Problem: " + response.getStatusLine().getStatusCode() + " payload: " + responseBuilder.toString());
            }
            return responseBuilder.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void webHook(String url, String ... parameters) {
        if (Strings.isNullOrEmpty((String)url)) {
            return;
        }
        HashMap<String, String> parametersMap = new HashMap<String, String>();
        for (int i = 0; i < parameters.length; i += 2) {
            parametersMap.put(parameters[i], parameters[i + 1]);
        }
        StrSubstitutor strSubstitutor = new StrSubstitutor(parametersMap);
        String webhook = strSubstitutor.replace(url);
        HTTPHelper.get(webhook);
    }

    public static String get(String url) {
        try {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpGet httpPost = new HttpGet(url);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            StringBuilder responseBuilder = new StringBuilder();
            responseBuilder.append(EntityUtils.toString((HttpEntity)response.getEntity()));
            httpclient.close();
            if (response.getStatusLine().getStatusCode() >= 300) {
                throw new RuntimeException("Problem httpCode: " + response.getStatusLine().getStatusCode() + " url: " + url + " payload: " + responseBuilder.toString());
            }
            return responseBuilder.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream getInputStream(String url) {
        try {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpGet httpPost = new HttpGet(url);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            return response.getEntity().getContent();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream getAsInputStream(String url) {
        try {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpGet httpPost = new HttpGet(url);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            return response.getEntity().getContent();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void get2File(String url, File fileName) {
        try {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpGet httpPost = new HttpGet(url);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            InputStream is = response.getEntity().getContent();
            FileOutputStream fos = new FileOutputStream(fileName);
            IOUtils.copy((InputStream)is, (OutputStream)fos);
            httpclient.close();
            fos.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static int getStatusCode(String url) {
        try {
            CloseableHttpClient httpclient = HttpClients.custom().disableRedirectHandling().build();
            HttpGet httpGet = new HttpGet(url);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            httpclient.close();
            return response.getStatusLine().getStatusCode();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getRedirectLocation(String url) {
        try {
            CloseableHttpClient httpclient = HttpClients.custom().disableRedirectHandling().build();
            HttpGet httpGet = new HttpGet(url);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            httpclient.close();
            Header location = response.getFirstHeader("Location");
            if (location == null) {
                return url;
            }
            return location.getValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getCookieValueFromHeader(String cookieName, HttpResponse response) {
        Header[] headers = response.getHeaders("Set-Cookie");
        if (headers == null) {
            return null;
        }
        for (int i = 0; i < headers.length; ++i) {
            Header header = headers[i];
            List<HttpCookie> cookies = HttpCookie.parse(header.getValue());
            for (HttpCookie cookie : cookies) {
                if (!cookie.getName().equals(cookieName)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public static String removeQueryParameter(String url) {
        if (Strings.isNullOrEmpty((String)url)) {
            return url;
        }
        int index = url.indexOf("?");
        if (index > 0) {
            return url.substring(0, index);
        }
        return url;
    }
}

