/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.http;

import com.google.common.io.ByteStreams;
import de.tblsoft.solr.util.IOUtils;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class Solr {
    private boolean showHeaders = false;

    public Solr(boolean showHeaders) {
        this.showHeaders = showHeaders;
    }

    public String feedFileToSolr(String url, String inputFileName) throws Exception {
        url = url + "/update?commit=true";
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        InputStream in = IOUtils.getInputStream(inputFileName);
        InputStreamEntity entity = new InputStreamEntity(in);
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
        StringBuilder responseBuilder = new StringBuilder();
        if (this.showHeaders) {
            responseBuilder.append(response.getStatusLine());
            responseBuilder.append("\n");
            for (Header header : response.getAllHeaders()) {
                responseBuilder.append(header.getName());
                responseBuilder.append(": ");
                responseBuilder.append(header.getValue());
                responseBuilder.append("\n");
            }
        }
        responseBuilder.append(EntityUtils.toString((HttpEntity)response.getEntity()));
        in.close();
        httpclient.close();
        return responseBuilder.toString();
    }

    public void retrieveFromSolr(String url, String outputFileName) throws Exception {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(url);
        OutputStream out = IOUtils.getOutputStream(outputFileName);
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
        InputStream in = response.getEntity().getContent();
        ByteStreams.copy((InputStream)in, (OutputStream)out);
        in.close();
        out.close();
        httpclient.close();
    }

    public String post(String url, String postString) throws Exception {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        StringEntity entity = new StringEntity(postString);
        httpPost.setEntity((HttpEntity)entity);
        httpPost.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
        StringBuilder responseBuilder = new StringBuilder();
        if (this.showHeaders) {
            responseBuilder.append(response.getStatusLine());
            responseBuilder.append("\n");
            responseBuilder.append("\n");
            responseBuilder.append("Request Header\n");
            this.printHeader(httpPost.getAllHeaders(), responseBuilder);
            responseBuilder.append("\n");
            responseBuilder.append("Response Header\n");
            this.printHeader(response.getAllHeaders(), responseBuilder);
        }
        responseBuilder.append(EntityUtils.toString((HttpEntity)response.getEntity()));
        httpclient.close();
        return responseBuilder.toString();
    }

    void printHeader(Header[] headers, StringBuilder responseBuilder) {
        for (Header header : headers) {
            responseBuilder.append(header.getName());
            responseBuilder.append(": ");
            responseBuilder.append(header.getValue());
            responseBuilder.append("\n");
        }
    }

    public String deleteByQuery(String url, String query) throws Exception {
        url = url + "/update?commit=true";
        String deleteQuery = "<delete><query>" + query + "</query></delete>";
        return this.post(url, deleteQuery);
    }

    public String truncate(String url) throws Exception {
        return this.deleteByQuery(url, "*:*");
    }
}

