/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.http;

import de.tblsoft.solr.bean.SolrConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.FileUtils;

public class SolrFile {
    public void createIndexWithCoreProperties(String solrHome, String coreName, String templateDir) throws Exception {
        this.copyIndex(solrHome, coreName, templateDir);
        FileInputStream fi = new FileInputStream(templateDir + "/core.properties");
        Properties p = new Properties();
        p.load(fi);
        fi.close();
        p.setProperty("name", coreName);
        FileOutputStream fr = new FileOutputStream(solrHome + "/" + coreName + "/core.properties");
        p.store(fr, "Properties");
        fr.close();
    }

    public void createIndexWithSolrXml(String solrHome, String coreName, String templateDir) throws Exception {
        String solrXml = solrHome + "/solr.xml";
        this.copyIndex(solrHome, coreName, templateDir);
        SolrConfiguration solrConfiguration = this.getSolrConfiguration(solrXml);
        solrConfiguration.getCores().addCore(coreName);
        this.writeSolrConfiguration(solrXml, solrConfiguration);
    }

    void copyIndex(String indexDir, String coreName, String templateDir) throws IOException {
        Files.createDirectory(Paths.get(indexDir + "/" + coreName, new String[0]), new FileAttribute[0]);
        FileUtils.copyDirectory((File)new File(templateDir + "/conf"), (File)new File(indexDir + "/" + coreName + "/conf"));
    }

    public SolrConfiguration getSolrConfiguration(String file) {
        try {
            File solrfile = new File(file);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{SolrConfiguration.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            SolrConfiguration solr = (SolrConfiguration)jaxbUnmarshaller.unmarshal(solrfile);
            return solr;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void writeSolrConfiguration(String file, SolrConfiguration solr) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{SolrConfiguration.class});
            File solrOut = new File(file);
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal((Object)solr, solrOut);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

