/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.log.parser;

import com.google.common.base.Strings;
import com.google.common.util.concurrent.AtomicLongMap;
import de.tblsoft.solr.log.parser.LogParser;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestCounter
extends LogParser {
    private static Logger LOG = LoggerFactory.getLogger(RequestCounter.class);
    private AtomicLongMap<String> count = AtomicLongMap.create();
    private static Map<String, String> aggregationOptions = new HashMap<String, String>();
    private String aggregationOption = "second";
    private long maxOutput = 150L;

    public RequestCounter(String file) {
        super(file);
    }

    @Override
    protected void line(Date date, String line) {
        SimpleDateFormat sdf = new SimpleDateFormat(aggregationOptions.get(this.aggregationOption));
        String aggregatedDate = sdf.format(date);
        this.count.incrementAndGet((Object)aggregatedDate);
    }

    public void print() {
        TreeSet keys = new TreeSet(this.count.asMap().keySet());
        long maxValue = (Long)Collections.max(this.count.asMap().values());
        LOG.info("max: " + maxValue);
        for (String key : keys) {
            long value = this.count.get((Object)key);
            long scaledValue = this.scale(value, this.maxOutput, maxValue);
            LOG.info(key + " : " + value + this.print(scaledValue));
        }
    }

    private String print(long n) {
        int i = 0;
        StringBuilder buffer = new StringBuilder(" ");
        while ((long)i++ < n) {
            char icon = '\u2b1b';
            buffer.append(icon);
        }
        return buffer.toString();
    }

    private long scale(long value, long scale, long max) {
        long f = value * scale / max;
        return f;
    }

    public void setAggregationOption(String aggregationOption) {
        if (!Strings.isNullOrEmpty((String)aggregationOption)) {
            this.aggregationOption = aggregationOption;
        }
    }

    static {
        aggregationOptions.put("second", "yyyy-MM-dd-kk:mm:ss");
        aggregationOptions.put("minute", "yyyy-MM-dd-kk:mm");
        aggregationOptions.put("hour", "yyyy-MM-dd-kk");
        aggregationOptions.put("day", "yyyy-MM-dd");
        aggregationOptions.put("month", "yyyy-MM");
        aggregationOptions.put("year", "yyyy");
    }
}

