/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.log.parser;

import de.tblsoft.solr.log.parser.SolrLogRow;
import de.tblsoft.solr.util.IOUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.client.utils.URLEncodedUtils;

public class SolrQueryLogParser {
    private Pattern pattern = Pattern.compile(".* \\[(.*)\\] webapp=(.*) path=(.*) params=\\{(.*)\\} hits=(.*) status=(.*) QTime=(.*)");
    private String file;

    public SolrQueryLogParser(String file) {
        this.file = file;
    }

    public void parse() throws Exception {
        String line;
        InputStream in = IOUtils.getInputStream(this.file);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        int currentCount = 0;
        Date currentDate = new Date();
        while ((line = br.readLine()) != null) {
            ++currentCount;
            Matcher m = this.pattern.matcher(line);
            if (m.matches()) {
                try {
                    ++currentCount;
                    SolrLogRow solrLogRow = this.parseRow(line, m, currentDate);
                    this.logRow(solrLogRow);
                }
                catch (Exception e) {
                    SolrLogRow item = new SolrLogRow();
                    item.setRaw(line);
                    this.logRowError(item, e);
                }
                continue;
            }
            currentDate = this.parseDate(line);
        }
        br.close();
    }

    protected void logRow(SolrLogRow solrLogRow) {
    }

    protected void logRowError(SolrLogRow solrLogRow, Exception e) {
    }

    SolrLogRow parseRow(String line, Matcher m, Date currentDate) {
        SolrLogRow item = new SolrLogRow();
        item.setRaw(line);
        String coreName = m.group(1);
        String webapp = m.group(2);
        String handler = m.group(3);
        String params = m.group(4);
        params = params.replaceAll("\\ ", " ");
        params = params.replaceAll("\\\"", " ");
        int hits = Integer.parseInt(m.group(5));
        int status = Integer.parseInt(m.group(6));
        int qTime = Integer.parseInt(m.group(7).trim());
        List urlParams = URLEncodedUtils.parse((String)params, (Charset)Charset.forName("UTF-8"));
        item.setCoreName(coreName);
        item.setWebapp(webapp);
        item.setHandler(handler);
        item.setLogFile(this.file);
        item.setTimestamp(currentDate);
        item.setHits(hits);
        item.setStatus(status);
        item.setqTime(qTime);
        return item;
    }

    protected Date parseDate(String line) {
        SimpleDateFormat sdf = new SimpleDateFormat("MMM dd, yyyy hh:mm:ss a 'org.apache.solr.core.SolrCore execute'", Locale.US);
        try {
            Date d = sdf.parse(line);
            return d;
        }
        catch (ParseException e) {
            return new Date();
        }
    }
}

