/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.logic;

import de.tblsoft.solr.parser.SolrXmlParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.ConcurrentUpdateSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.common.SolrInputDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SolrFeeder
extends SolrXmlParser {
    private static Logger LOG = LoggerFactory.getLogger(SolrFeeder.class);
    private List<String> ignoreFields = new ArrayList<String>();
    private SolrClient server;
    private SolrInputDocument inputDoc = new SolrInputDocument();
    private String serverUrl;
    private int queueSize = 1;
    private int threads = 1;
    private boolean deleteIndex = false;

    public SolrFeeder(String server) {
        this.serverUrl = server;
    }

    public void doFeed() throws Exception {
        this.server = new ConcurrentUpdateSolrClient(this.serverUrl, this.queueSize, this.threads);
        if (this.threads == 1 && this.queueSize == 1) {
            this.server = new HttpSolrClient(this.serverUrl);
        }
        if (this.deleteIndex) {
            LOG.info("Delete the index.");
            this.server.deleteByQuery("*:*");
        }
        this.parse();
        this.server.commit();
        this.server.optimize();
        this.server.close();
    }

    @Override
    public void field(String name, String value) {
        if (!this.isFieldIgnored(name)) {
            this.inputDoc.addField(name, (Object)value);
        }
    }

    private boolean isFieldIgnored(String name) {
        for (String pattern : this.ignoreFields) {
            if (!name.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void endDocument() {
        try {
            this.server.add(this.inputDoc);
        }
        catch (SolrServerException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.inputDoc = new SolrInputDocument();
    }

    public void setIgnoreFields(List<String> ignoreFields) {
        this.ignoreFields = ignoreFields;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public void setDeleteIndex(boolean deleteIndex) {
        this.deleteIndex = deleteIndex;
    }
}

