/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.logic;

import de.tblsoft.solr.parser.SolrXmlParser;
import de.tblsoft.solr.util.IOUtils;
import de.tblsoft.solr.util.OutputStreamStringBuilder;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SpecialCharacterExtractor
extends SolrXmlParser {
    private Map<String, String> dictionary = new HashMap<String, String>();
    private Set<String> currentChars = new HashSet<String>();
    private String currentArticleCode;
    private String outputFileName;
    private String idField = "articleCode_exact";
    private String allowedChars = "[a-zA-Z0-9-]+";
    private int maxItems = 50;

    public void extractSpecialCharacters() throws Exception {
        this.parse();
        OutputStream out = IOUtils.getOutputStream(this.outputFileName);
        OutputStreamStringBuilder dict = new OutputStreamStringBuilder(out);
        for (Map.Entry<String, String> entry : this.dictionary.entrySet()) {
            dict.append(entry.getKey());
            dict.append(" : ");
            if (entry.getValue().length() > this.maxItems) {
                dict.append(entry.getValue().substring(0, this.maxItems));
            } else {
                dict.append(entry.getValue());
            }
            dict.append("\n");
        }
        out.close();
    }

    @Override
    public void field(String name, String value) {
        if (this.idField.equals(name)) {
            this.currentArticleCode = value;
        }
        value = value.replaceAll(this.allowedChars, "");
        for (int i = 0; i < value.length(); ++i) {
            String valueChar = String.valueOf(value.charAt(i));
            this.currentChars.add(valueChar);
        }
    }

    @Override
    public void endDocument() {
        for (String value : this.currentChars) {
            String articleCodes = this.dictionary.get(value);
            articleCodes = articleCodes == null ? this.currentArticleCode : articleCodes + "," + this.currentArticleCode;
            this.dictionary.put(value, articleCodes);
        }
        this.currentChars = new HashSet<String>();
        this.currentArticleCode = null;
        super.endDocument();
    }

    public void setOutputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    public void setMaxItems(int maxItems) {
        this.maxItems = maxItems;
    }

    public void setAllowedChars(String allowedChars) {
        this.allowedChars = allowedChars;
    }

    public void setIdField(String idField) {
        this.idField = idField;
    }
}

