/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.logic.iban;

import java.util.Random;

public class RandomIbanGenerator {
    private boolean random = true;
    private String countryCode = "DE";
    private String checkDigits = "89";
    private String blz = "12345678";
    private String accountNumber = "1234567890";

    public String getRandomIban() {
        StringBuilder iban = new StringBuilder();
        if (this.random) {
            this.checkDigits = RandomIbanGenerator.generateRandomDigitsString(2);
            this.blz = RandomIbanGenerator.generateRandomDigitsString(8);
            this.accountNumber = RandomIbanGenerator.generateRandomDigitsString(10);
        }
        iban.append(this.countryCode);
        iban.append(this.checkDigits);
        iban.append(this.blz);
        iban.append(this.accountNumber);
        return iban.toString();
    }

    public static String generateRandomDigitsString(int n) {
        String value = String.valueOf(RandomIbanGenerator.generateRandomDigits(n));
        return value;
    }

    public static int generateRandomDigits(int n) {
        int m = (int)Math.pow(10.0, n - 1);
        return m + new Random().nextInt(9 * m);
    }

    public boolean isRandom() {
        return this.random;
    }

    public void setRandom(boolean random) {
        this.random = random;
    }
}

