/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.parser;

import de.tblsoft.solr.util.IOUtils;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class SolrXmlParser {
    private String inputFileName;

    public String getInputFileName() {
        return this.inputFileName;
    }

    public void setInputFileName(String inputFileName) {
        this.inputFileName = inputFileName;
    }

    public void parse() throws Exception {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        InputStream is = IOUtils.getInputStream(this.getInputFileName());
        XMLEventReader xmlEventReader = xmlInputFactory.createXMLEventReader(is);
        boolean isDoc = false;
        boolean isFacet = false;
        boolean isArr = false;
        int lstCounter = 0;
        String currentValue = "";
        String currentName = "";
        List<String> possibleStartElements = Arrays.asList("date,arr,str,bool,double,float,long,int".split(","));
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = xmlEventReader.nextEvent();
            if (xmlEvent.isStartElement()) {
                StartElement startElement = xmlEvent.asStartElement();
                if (startElement.getAttributeByName(new QName("name")) != null) {
                    currentName = startElement.getAttributeByName(new QName("name")).getValue();
                }
                if (startElement.getName().getLocalPart().equals("doc")) {
                    isDoc = true;
                }
                if (!startElement.getName().getLocalPart().equals("lst")) continue;
                ++lstCounter;
                if (!isFacet || !"facet_fields".equals(currentName)) continue;
                isFacet = true;
                continue;
            }
            if (xmlEvent.isEndElement()) {
                EndElement endElement = xmlEvent.asEndElement();
                if (endElement.getName().getLocalPart().equals("doc")) {
                    isDoc = false;
                    this.endDocument();
                    continue;
                }
                if (endElement.getName().getLocalPart().equals("arr")) {
                    currentName = "";
                    continue;
                }
                if (isDoc && possibleStartElements.contains(endElement.getName().getLocalPart())) {
                    if (currentName != null && !"".equals(currentName)) {
                        this.field(currentName, currentValue);
                    }
                    currentValue = "";
                    continue;
                }
                if (!endElement.getName().getLocalPart().equals("lst")) continue;
                --lstCounter;
                continue;
            }
            if (!xmlEvent.isCharacters()) continue;
            Characters characters = xmlEvent.asCharacters();
            currentValue = characters.getData();
        }
        is.close();
        xmlEventReader.close();
    }

    public void field(String name, String value) {
    }

    public void endDocument() {
    }
}

