/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline;

import com.google.common.base.Strings;
import de.tblsoft.solr.pipeline.FilterIF;
import de.tblsoft.solr.pipeline.PipelineExecuter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.Filter;
import de.tblsoft.solr.util.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.text.StrSubstitutor;

public abstract class AbstractFilter
implements FilterIF {
    protected FilterIF nextFilter;
    protected Filter filter;
    private String baseDir;
    protected Map<String, String> variables = new HashMap<String, String>();
    protected PipelineExecuter pipelineExecuter;

    @Override
    public void setVariables(Map<String, String> variables) {
        if (variables == null) {
            return;
        }
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            this.variables.put("variables." + entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void init() {
        this.nextFilter.init();
    }

    @Override
    public void setFilterConfig(Filter filter) {
        this.filter = filter;
    }

    @Override
    public void document(Document document) {
        this.nextFilter.document(document);
    }

    @Override
    public void end() {
        this.nextFilter.end();
    }

    @Override
    public void setNextFilter(FilterIF filter) {
        this.nextFilter = filter;
    }

    public String getProperty(String name, String defaultValue) {
        if (this.filter.getProperty() == null) {
            return defaultValue;
        }
        String value = (String)this.filter.getProperty().get(name);
        if (value != null) {
            StrSubstitutor strSubstitutor = new StrSubstitutor(this.variables);
            value = strSubstitutor.replace(value);
            return value;
        }
        return defaultValue;
    }

    public Boolean getPropertyAsBoolean(String name, Boolean defaultValue) {
        String value = this.getProperty(name, null);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    public List<String> getPropertyAsList(String name, List<String> defaultValue) {
        if (this.filter.getProperty() == null) {
            return defaultValue;
        }
        List value = (List)this.filter.getProperty().get(name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public Map<String, String> getPropertyAsMapping(String name) {
        return this.getPropertyAsMapping(name, new HashMap<String, String>(), "->");
    }

    public Map<String, String> getPropertyAsMapping(String name, Map<String, String> defaultValue) {
        return this.getPropertyAsMapping(name, defaultValue, "->");
    }

    public Map<String, String> getPropertyAsMapping(String name, Map<String, String> defaultValue, String splitter) {
        if (this.filter.getProperty() == null) {
            return defaultValue;
        }
        HashMap<String, String> mapping = new HashMap<String, String>();
        List<String> rawValues = this.getPropertyAsList(name, new ArrayList<String>());
        for (String rawValue : rawValues) {
            String[] splittedValue = rawValue.split(splitter);
            if (splittedValue.length < 2) {
                throw new RuntimeException("The mapping is not correct configured: " + rawValue);
            }
            mapping.put(splittedValue[0], splittedValue[1]);
        }
        return mapping;
    }

    public int getPropertyAsInt(String name, int defaultValue) {
        String value = this.getProperty(name, null);
        if (value != null) {
            return Integer.valueOf(value);
        }
        return defaultValue;
    }

    public float getPropertyAsFloat(String name, float defaultValue) {
        String value = this.getProperty(name, null);
        if (value != null) {
            return Float.valueOf(value).floatValue();
        }
        return defaultValue;
    }

    public Date getPropertyAsDate(String name, Date defaultValue) {
        String value = this.getProperty(name, null);
        if (value != null) {
            return DateUtils.getDate(value);
        }
        return defaultValue;
    }

    public void verify(String value, String message) {
        if (Strings.isNullOrEmpty((String)value)) {
            throw new RuntimeException(message);
        }
    }

    public void verify(List<String> value, String message) {
        if (value == null) {
            throw new RuntimeException(message);
        }
    }

    public String[] getPropertyAsArray(String name, String[] defaultValue) {
        List<String> list = this.getPropertyAsList(name, null);
        if (list == null) {
            return defaultValue;
        }
        return list.toArray(new String[list.size()]);
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    @Override
    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    @Override
    public String getId() {
        return this.filter.getId();
    }

    @Override
    public void setPipelineExecuter(PipelineExecuter pipelineExecuter) {
        this.pipelineExecuter = pipelineExecuter;
    }

    public PipelineExecuter getPipelineExecuter() {
        return this.pipelineExecuter;
    }
}

