/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline;

import de.tblsoft.solr.pipeline.AbstractReader;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVReader
extends AbstractReader {
    private static Logger LOG = LoggerFactory.getLogger(CSVReader.class);
    private boolean addMeta = false;
    private boolean failOnError = false;
    private String charset = StandardCharsets.UTF_8.name();

    @Override
    public void read() {
        this.addMeta = this.getPropertyAsBoolean("addMeta", false);
        this.failOnError = this.getPropertyAsBoolean("failOnError", false);
        this.charset = this.getProperty("charset", StandardCharsets.UTF_8.name());
        try {
            List<String> filenames = this.getPropertyAsList("filenames", new ArrayList<String>());
            if (filenames.isEmpty()) {
                String singleFile = this.getProperty("filename", null);
                filenames.add(singleFile);
            }
            for (String filename : filenames) {
                try {
                    this.processFile(filename);
                }
                catch (Exception e) {
                    if (this.failOnError) {
                        throw e;
                    }
                    LOG.error("Could not process file " + filename + " because: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void processFile(String filename) throws IOException {
        String absoluteFilename = IOUtils.getAbsoluteFile(this.getBaseDir(), filename);
        Long maxRows = this.getPropertyAsInteger("maxRows", Long.MAX_VALUE);
        String delimiter = this.getProperty("delimiter", ",");
        String quote = this.getProperty("quote", null);
        String arrayDelimiter = this.getProperty("arrayDelimiter", null);
        String[] headers = this.getPropertyAsArray("headers", null);
        InputStream in = IOUtils.getInputStream(absoluteFilename);
        InputStreamReader reader = new InputStreamReader(in, this.charset);
        CSVFormat format = CSVFormat.RFC4180;
        format = headers == null ? format.withHeader(new String[0]) : format.withHeader(headers);
        format = format.withDelimiter(delimiter.charAt(0));
        if ("null".equals(quote)) {
            format = format.withQuote(null);
        } else if (quote != null) {
            format = format.withQuote(quote.charAt(0));
        }
        CSVParser parser = format.parse((Reader)reader);
        Iterator csvIterator = parser.iterator();
        long rowNumber = 0L;
        while (csvIterator.hasNext() && rowNumber < maxRows) {
            ++rowNumber;
            CSVRecord record = (CSVRecord)csvIterator.next();
            Map header = parser.getHeaderMap();
            Document document = new Document();
            for (Map.Entry entry : header.entrySet()) {
                String key = (String)entry.getKey();
                try {
                    String value = record.get(key);
                    if (StringUtils.isEmpty((CharSequence)arrayDelimiter)) {
                        document.addField(key, value);
                        continue;
                    }
                    ArrayList<String> valueList = new ArrayList<String>();
                    String[] values = value.split(arrayDelimiter);
                    if (values.length > 0) {
                        for (String val : values) {
                            if (!StringUtils.isNotEmpty((CharSequence)val)) continue;
                            valueList.add(val);
                        }
                    }
                    document.setField(key, (List<String>)valueList);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            if (this.addMeta) {
                document.addField("rowNumber", String.valueOf(rowNumber));
                document.addField("fileName", absoluteFilename);
            }
            this.executer.document(document);
        }
        in.close();
    }
}

