/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import de.tblsoft.solr.http.HTTPHelper;
import de.tblsoft.solr.pipeline.AbstractReader;
import de.tblsoft.solr.pipeline.PipelineExecuter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.Reader;
import de.tblsoft.solr.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class DocumentReader
extends AbstractReader {
    ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public void read() {
        try {
            String url = this.getProperty("url", null);
            String filename = this.getProperty("filename", null);
            this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            if (!Strings.isNullOrEmpty((String)url)) {
                DocumentContext context = this.loadJsonContextFromUrl(url);
                this.execute(context, url);
            } else if (!Strings.isNullOrEmpty((String)filename)) {
                File jsonFile = IOUtils.getAbsoluteFileAsFile(this.getBaseDir(), filename);
                DocumentContext context = this.loadJsonContextFromFile(jsonFile);
                this.execute(context, filename);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void execute(DocumentContext context, String source) {
        List jsonHits = (List)context.read("$", new Predicate[0]);
        for (Object obj : jsonHits) {
            Map doc = (Map)obj;
            Document document = new Document();
            for (Map.Entry entry : doc.entrySet()) {
                document.setField((String)entry.getKey(), entry.getValue());
            }
            this.executer.document(document);
        }
    }

    protected DocumentContext loadJsonContextFromUrl(String url) throws IOException {
        String jsonBody = HTTPHelper.get(url);
        DocumentContext context = JsonPath.parse((String)jsonBody);
        return context;
    }

    protected DocumentContext loadJsonContextFromFile(File jsonFile) throws IOException {
        DocumentContext context = JsonPath.parse((File)jsonFile);
        return context;
    }

    @Override
    public void setPipelineExecuter(PipelineExecuter executer) {
        this.executer = executer;
    }

    @Override
    public void end() {
    }

    @Override
    public void setReader(Reader reader) {
        this.reader = reader;
    }
}

