/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.Field;
import de.tblsoft.solr.util.IOUtils;
import de.tblsoft.solr.util.OutputStreamStringBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;

public class DocumentWriter
extends AbstractFilter {
    private String filename;
    private OutputStreamStringBuilder outputStreamStringBuilder;
    private OutputStream outputStream;
    private ObjectMapper objectMapper = new ObjectMapper();
    private boolean isFirstDocument = true;

    @Override
    public void init() {
        String relativeFilename = this.getProperty("filename", null);
        this.filename = IOUtils.getAbsoluteFile(this.getBaseDir(), relativeFilename);
        this.verify(this.filename, "For the FileLineWriter a filname must be defined.");
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            this.outputStream = IOUtils.getOutputStream(this.filename);
            this.outputStreamStringBuilder = new OutputStreamStringBuilder(this.outputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.outputStreamStringBuilder.append("[");
        super.init();
    }

    @Override
    public void document(Document document) {
        try {
            if (this.isFirstDocument) {
                this.isFirstDocument = false;
            } else {
                this.outputStreamStringBuilder.append(",");
            }
            HashMap<String, Object> outputDocument = new HashMap<String, Object>();
            for (Field field : document.getFields()) {
                if (field.getValues().size() == 1) {
                    outputDocument.put(field.getName(), field.getValue());
                    continue;
                }
                outputDocument.put(field.getName(), field.getValues());
            }
            this.outputStreamStringBuilder.append(this.objectMapper.writeValueAsString(outputDocument));
            super.document(document);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void end() {
        this.outputStreamStringBuilder.append("]");
        try {
            this.outputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        super.end();
    }
}

