/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import de.tblsoft.solr.http.ElasticHelper;
import de.tblsoft.solr.http.HTTPHelper;
import de.tblsoft.solr.pipeline.AbstractReader;
import de.tblsoft.solr.pipeline.PipelineExecuter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.Reader;
import de.tblsoft.solr.pipeline.filter.SimpleMapping;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ElasticJsonPathReader
extends AbstractReader {
    private String url;
    private String scroll;

    @Override
    public void read() {
        String response = "";
        String pagedUrl = "";
        String scrollId = "";
        boolean hasHits = false;
        SimpleMapping simpleMapping = new SimpleMapping(this.getPropertyAsList("mapping", new ArrayList<String>()), this.getPropertyAsList("config", new ArrayList<String>()));
        Map<String, List<String>> mapping = simpleMapping.getMapping();
        try {
            this.url = this.getProperty("url", null);
            this.scroll = this.getProperty("scroll", "1m");
            String scrollBaseUrl = ElasticHelper.getScrollUrl(this.url);
            pagedUrl = this.url + "&scroll=" + this.scroll;
            do {
                response = HTTPHelper.get(pagedUrl);
                DocumentContext context = JsonPath.parse((String)response);
                scrollId = (String)context.read("$['_scroll_id']", new Predicate[0]);
                List elasticHits = (List)context.read("$['hits']['hits'][*]['_source']", new Predicate[0]);
                hasHits = false;
                boolean count = false;
                for (Object obj : elasticHits) {
                    hasHits = true;
                    Document document = new Document();
                    for (Map.Entry<String, List<String>> mappingEntry : mapping.entrySet()) {
                        try {
                            Object parsedValue = JsonPath.parse(obj).read(mappingEntry.getKey(), new Predicate[0]);
                            for (String target : mappingEntry.getValue()) {
                                document.setField(target, parsedValue);
                            }
                        }
                        catch (PathNotFoundException pathNotFoundException) {
                        }
                    }
                    this.executer.document(document);
                }
                pagedUrl = scrollBaseUrl + "?scroll=" + this.scroll + "&scroll_id=" + scrollId;
            } while (hasHits);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setPipelineExecuter(PipelineExecuter executer) {
        this.executer = executer;
    }

    @Override
    public void end() {
    }

    @Override
    public void setReader(Reader reader) {
        this.reader = reader;
    }
}

