/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.tblsoft.solr.elastic.ElasticScrollQuery;
import de.tblsoft.solr.pipeline.AbstractReader;
import de.tblsoft.solr.pipeline.PipelineExecuter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.Reader;
import de.tblsoft.solr.util.IOUtils;
import java.io.File;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class ElasticReader
extends AbstractReader {
    private Gson gson;
    private String url;
    private String scroll;

    @Override
    public void read() {
        GsonBuilder builder = new GsonBuilder();
        this.gson = builder.create();
        String response = "";
        String pagedUrl = "";
        String scrollId = "";
        boolean hasHits = false;
        try {
            List<Document> docs;
            this.url = this.getProperty("url", null);
            this.scroll = this.getProperty("scroll", "1m");
            String requestFilename = this.getProperty("requestFilename", null);
            ElasticScrollQuery elasticScrollQuery = new ElasticScrollQuery(this.url);
            elasticScrollQuery.setScroll(this.scroll);
            if (requestFilename != null) {
                String absoluteRequestFilename = IOUtils.getAbsoluteFile(this.getBaseDir(), requestFilename);
                String request = FileUtils.readFileToString((File)new File(absoluteRequestFilename));
                elasticScrollQuery.setRequest(request);
            }
            while ((docs = elasticScrollQuery.nextDocuments()) != null) {
                for (Document document : docs) {
                    this.executer.document(document);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setPipelineExecuter(PipelineExecuter executer) {
        this.executer = executer;
    }

    @Override
    public void end() {
    }

    @Override
    public void setReader(Reader reader) {
        this.reader = reader;
    }
}

