/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline;

import com.google.common.base.Strings;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import de.tblsoft.solr.pipeline.AbstractReader;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.util.IOUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ElasticdumpJsonReader
extends AbstractReader {
    private String filepath;
    private String format;
    private String jsonPathRoot;

    @Override
    public void read() {
        this.filepath = this.getProperty("filepath", null);
        if (Strings.isNullOrEmpty((String)this.filepath)) {
            throw new RuntimeException("For the ElasticdumpJsonReader a filepath property must be defined!");
        }
        this.format = this.getProperty("format", "elasticdump");
        this.jsonPathRoot = "elasticdump".equals(this.format) ? "$['_source']" : "$";
        try {
            this.readFileAsLines(this.filepath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void readFileAsLines(String filepath) throws IOException {
        BufferedReader br = null;
        FileReader fr = null;
        try {
            String line;
            File jsonFile = IOUtils.getAbsoluteFileAsFile(this.getBaseDir(), filepath);
            fr = new FileReader(jsonFile);
            br = new BufferedReader(fr);
            while ((line = br.readLine()) != null) {
                Document doc = ElasticdumpJsonReader.parseJsonLineAsDoc(line, this.jsonPathRoot);
                if ("bulk".equals(this.format)) {
                    String lineSource = br.readLine();
                    Document docSource = ElasticdumpJsonReader.parseJsonLineAsDoc(lineSource, this.jsonPathRoot);
                    docSource.setField("_index", doc.getFieldValue("_index"));
                    docSource.setField("_type", doc.getFieldValue("_type"));
                    docSource.setField("_id", doc.getFieldValue("_id"));
                    doc = docSource;
                }
                this.executer.document(doc);
            }
        }
        catch (FileNotFoundException e) {
            throw new IOException(e);
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (fr != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected static Document parseJsonLineAsDoc(String jsonLine, String jsonSourcePath) {
        DocumentContext context = JsonPath.parse((String)jsonLine);
        Document doc = new Document();
        doc.setField("_index", (String)ElasticdumpJsonReader.readJsonValueOrNull(context, "$['_index']"));
        doc.setField("_type", (String)ElasticdumpJsonReader.readJsonValueOrNull(context, "$['_type']"));
        doc.setField("_id", (String)ElasticdumpJsonReader.readJsonValueOrNull(context, "$['_id']"));
        Map source = (Map)ElasticdumpJsonReader.readJsonValueOrNull(context, jsonSourcePath);
        Map<String, Object> flatSource = ElasticdumpJsonReader.flatSourceToDocument(source);
        if (flatSource != null) {
            for (Map.Entry<String, Object> entry : flatSource.entrySet()) {
                doc.addField(entry.getKey(), entry.getValue());
            }
        }
        return doc;
    }

    protected static <T> T readJsonValueOrNull(DocumentContext context, String jsonPath) {
        Object result = null;
        try {
            result = context.read(jsonPath, new Predicate[0]);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return (T)result;
    }

    protected static Map<String, Object> flatSourceToDocument(Map<String, Object> source) {
        HashMap<String, Object> document = new HashMap<String, Object>();
        if (source != null) {
            document = new HashMap();
            for (Map.Entry<String, Object> entry : source.entrySet()) {
                Map<String, Object> fields = ElasticdumpJsonReader.flatValueToFields(entry.getKey(), entry.getValue());
                document.putAll(fields);
            }
        }
        return document;
    }

    protected static Map<String, Object> flatValueToFields(String field, Object value) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        if (value instanceof Map) {
            for (Map.Entry entry : ((Map)value).entrySet()) {
                String key = field + "." + (String)entry.getKey();
                Map<String, Object> map = ElasticdumpJsonReader.flatValueToFields(key, entry.getValue());
                fields.putAll(map);
            }
        } else {
            fields.put(field, value);
        }
        return fields;
    }
}

