/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.Field;
import de.tblsoft.solr.util.IOUtils;
import de.tblsoft.solr.util.OutputStreamStringBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class FileLineWriter
extends AbstractFilter {
    private String filename;
    private OutputStreamStringBuilder outputStreamStringBuilder;
    private OutputStream outputStream;
    private List<String> fieldNames;
    private String fieldSeperator;
    private String documentSeperator;

    @Override
    public void init() {
        String relativeFilename = this.getProperty("filename", null);
        this.fieldNames = this.getPropertyAsList("fieldNames", null);
        this.fieldSeperator = this.getProperty("fieldSeperator", ",");
        this.documentSeperator = this.getProperty("documentSeperator", "\n");
        this.filename = IOUtils.getAbsoluteFile(this.getBaseDir(), relativeFilename);
        this.verify(this.filename, "For the FileLineWriter a filname must be defined.");
        try {
            this.outputStream = IOUtils.getOutputStream(this.filename);
            this.outputStreamStringBuilder = new OutputStreamStringBuilder(this.outputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        super.init();
    }

    @Override
    public void document(Document document) {
        if (this.fieldNames == null) {
            for (Field field : document.getFields()) {
                for (String value : field.getValues()) {
                    this.field(field.getName(), value);
                }
            }
        } else {
            for (String fieldName : this.fieldNames) {
                Field field = document.getField(fieldName);
                if (field == null) continue;
                for (String value : field.getValues()) {
                    this.field(field.getName(), value);
                }
            }
        }
        this.endDocument(document);
        super.document(document);
    }

    public void field(String name, String value) {
        this.outputStreamStringBuilder.append(value);
        this.outputStreamStringBuilder.append(this.fieldSeperator);
    }

    public void endDocument(Document document) {
        this.outputStreamStringBuilder.append(this.documentSeperator);
    }

    @Override
    public void end() {
        try {
            this.outputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        super.end();
    }
}

