/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import de.tblsoft.solr.pipeline.AbstractReader;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.util.IOUtils;
import java.io.BufferedReader;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class FilelineReader
extends AbstractReader {
    @Override
    public void read() {
        boolean addMeta = false;
        String charset = this.getProperty("charset", StandardCharsets.UTF_8.name());
        String filename = this.getProperty("filename", null);
        String absoluteFilename = IOUtils.getAbsoluteFile(this.getBaseDir(), filename);
        addMeta = this.getPropertyAsBoolean("addMeta", false);
        Long maxRows = this.getPropertyAsInteger("maxRows", Long.MAX_VALUE);
        String delimiter = this.getProperty("delimiter", ",");
        String commentPrefix = this.getProperty("commentPrefix", "#");
        String fieldName = this.getProperty("fieldName", "line");
        try {
            String line;
            BufferedReader br = Files.newReader((File)new File(absoluteFilename), (Charset)Charset.forName(charset));
            long countLines = 0L;
            while ((line = br.readLine()) != null && ++countLines <= maxRows) {
                if (line.startsWith(commentPrefix) || Strings.isNullOrEmpty((String)line)) continue;
                Document document = new Document();
                for (String item : Splitter.on((String)delimiter).trimResults().split((CharSequence)line)) {
                    document.addField(fieldName, item);
                }
                this.executer.document(document);
            }
            br.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

